@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.MoveCollectionArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.MoveCollectionPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.MoveCollectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the move collection.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### MoveCollections_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var moveCollection = new AzureNative.Migrate.MoveCollection("moveCollection", new()
 *     {
 *         Identity = new AzureNative.Migrate.Inputs.IdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "eastus2",
 *         MoveCollectionName = "movecollection1",
 *         Properties = new AzureNative.Migrate.Inputs.MoveCollectionPropertiesArgs
 *         {
 *             SourceRegion = "eastus",
 *             TargetRegion = "westus",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMoveCollection(ctx, "moveCollection", &migrate.MoveCollectionArgs{
 * 			Identity: &migrate.IdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location:           pulumi.String("eastus2"),
 * 			MoveCollectionName: pulumi.String("movecollection1"),
 * 			Properties: &migrate.MoveCollectionPropertiesArgs{
 * 				SourceRegion: pulumi.String("eastus"),
 * 				TargetRegion: pulumi.String("westus"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MoveCollection;
 * import com.pulumi.azurenative.migrate.MoveCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var moveCollection = new MoveCollection("moveCollection", MoveCollectionArgs.builder()
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus2")
 *             .moveCollectionName("movecollection1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("sourceRegion", "eastus"),
 *                 Map.entry("targetRegion", "westus")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MoveCollection movecollection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}
 * ```
 * @property identity Defines the MSI properties of the Move Collection.
 * @property location The geo-location where the resource lives.
 * @property moveCollectionName The Move Collection Name.
 * @property properties Defines the move collection properties.
 * @property resourceGroupName The Resource Group Name.
 * @property tags Resource tags.
 */
public data class MoveCollectionArgs(
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val moveCollectionName: Output<String>? = null,
    public val properties: Output<MoveCollectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.MoveCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.MoveCollectionArgs =
        com.pulumi.azurenative.migrate.MoveCollectionArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .moveCollectionName(moveCollectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MoveCollectionArgs].
 */
@PulumiTagMarker
public class MoveCollectionArgsBuilder internal constructor() {
    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var moveCollectionName: Output<String>? = null

    private var properties: Output<MoveCollectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Defines the MSI properties of the Move Collection.
     */
    @JvmName("alxgigioshrowrux")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("fkxyounldbkiwuwk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Move Collection Name.
     */
    @JvmName("ogklmgnocmobenbv")
    public suspend fun moveCollectionName(`value`: Output<String>) {
        this.moveCollectionName = value
    }

    /**
     * @param value Defines the move collection properties.
     */
    @JvmName("nujekfdldumugscl")
    public suspend fun properties(`value`: Output<MoveCollectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("ybudncmykkdiquyl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ntejajwwufedyjdp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines the MSI properties of the Move Collection.
     */
    @JvmName("uruypoqensgcmukj")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Defines the MSI properties of the Move Collection.
     */
    @JvmName("ashxloynsysnntbn")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("umirhhjeyvuwpplm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Move Collection Name.
     */
    @JvmName("pfyjvlwdvpwhjhsk")
    public suspend fun moveCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moveCollectionName = mapped
    }

    /**
     * @param value Defines the move collection properties.
     */
    @JvmName("xgqaefvijqxxlnem")
    public suspend fun properties(`value`: MoveCollectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Defines the move collection properties.
     */
    @JvmName("rnlvmmxqaoqcbrej")
    public suspend fun properties(argument: suspend MoveCollectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MoveCollectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("wvehcytdbwwsdids")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("crgsgrhkhojiegqh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nbtlgfediggxdxcc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MoveCollectionArgs = MoveCollectionArgs(
        identity = identity,
        location = location,
        moveCollectionName = moveCollectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
