@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.SolutionPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SolutionPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Solution].
 */
@PulumiTagMarker
public class SolutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SolutionArgs = SolutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SolutionArgsBuilder.() -> Unit) {
        val builder = SolutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Solution {
        val builtJavaResource = com.pulumi.azurenative.migrate.Solution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Solution(builtJavaResource)
    }
}

/**
 * Solution REST Resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### Solutions_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.Migrate.Solution("solution", new()
 *     {
 *         MigrateProjectName = "project01",
 *         Properties = new AzureNative.Migrate.Inputs.SolutionPropertiesArgs
 *         {
 *             Goal = "Databases",
 *             Purpose = "Assessment",
 *             Tool = "DataMigrationAssistant",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SolutionName = "dbsolution",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSolution(ctx, "solution", &migrate.SolutionArgs{
 * 			MigrateProjectName: pulumi.String("project01"),
 * 			Properties: &migrate.SolutionPropertiesArgs{
 * 				Goal:    pulumi.String("Databases"),
 * 				Purpose: pulumi.String("Assessment"),
 * 				Tool:    pulumi.String("DataMigrationAssistant"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SolutionName:      pulumi.String("dbsolution"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Solution;
 * import com.pulumi.azurenative.migrate.SolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .migrateProjectName("project01")
 *             .properties(Map.ofEntries(
 *                 Map.entry("goal", "Databases"),
 *                 Map.entry("purpose", "Assessment"),
 *                 Map.entry("tool", "DataMigrationAssistant")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .solutionName("dbsolution")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Solution dbsolution /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/solutions/{solutionName}
 * ```
 */
public class Solution internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.Solution,
) : KotlinCustomResource(javaResource, SolutionMapper) {
    /**
     * Gets or sets the ETAG for optimistic concurrency control.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the name of this REST resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the properties of the solution.
     */
    public val properties: Output<SolutionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Gets the type of this REST resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SolutionMapper : ResourceMapper<Solution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.Solution::class == javaResource::class

    override fun map(javaResource: Resource): Solution = Solution(
        javaResource as
            com.pulumi.azurenative.migrate.Solution,
    )
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Solution].
 */
public suspend fun solution(name: String, block: suspend SolutionResourceBuilder.() -> Unit):
    Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun solution(name: String): Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
