@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse.Companion.toKotlin as collectorAgentPropertiesBaseResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SqlCollectorOperation].
 */
@PulumiTagMarker
public class SqlCollectorOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlCollectorOperationArgs = SqlCollectorOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlCollectorOperationArgsBuilder.() -> Unit) {
        val builder = SqlCollectorOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlCollectorOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.SqlCollectorOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlCollectorOperation(builtJavaResource)
    }
}

/**
 * The SQL collector REST object.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### SqlCollectorOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlCollectorOperation = new AzureNative.Migrate.SqlCollectorOperation("sqlCollectorOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "630da710-4d44-41f7-a189-72fe3db5502b-agent",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "db9c4c3d-477c-4d5a-817b-318276713565",
 *                 Audience = "db9c4c3d-477c-4d5a-817b-318276713565",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "e50236ad-ad07-47d4-af71-ed7b52d200d5",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         CollectorName = "fci-test0c1esqlsitecollector",
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/bansalankit-rg/providers/Microsoft.OffAzure/MasterSites/fci-ankit-test6065mastersite/SqlSites/fci-ankit-test6065sqlsites",
 *         ProjectName = "fci-test6904project",
 *         ResourceGroupName = "rgmigrate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSqlCollectorOperation(ctx, "sqlCollectorOperation", &migrate.SqlCollectorOperationArgs{
 * 			AgentProperties: migrate.CollectorAgentPropertiesBaseResponse{
 * 				Id: pulumi.String("630da710-4d44-41f7-a189-72fe3db5502b-agent"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("db9c4c3d-477c-4d5a-817b-318276713565"),
 * 					Audience:      pulumi.String("db9c4c3d-477c-4d5a-817b-318276713565"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("e50236ad-ad07-47d4-af71-ed7b52d200d5"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			CollectorName:     pulumi.String("fci-test0c1esqlsitecollector"),
 * 			DiscoverySiteId:   pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/bansalankit-rg/providers/Microsoft.OffAzure/MasterSites/fci-ankit-test6065mastersite/SqlSites/fci-ankit-test6065sqlsites"),
 * 			ProjectName:       pulumi.String("fci-test6904project"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SqlCollectorOperation;
 * import com.pulumi.azurenative.migrate.SqlCollectorOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlCollectorOperation = new SqlCollectorOperation("sqlCollectorOperation", SqlCollectorOperationArgs.builder()
 *             .agentProperties(Map.ofEntries(
 *                 Map.entry("id", "630da710-4d44-41f7-a189-72fe3db5502b-agent"),
 *                 Map.entry("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "db9c4c3d-477c-4d5a-817b-318276713565"),
 *                     Map.entry("audience", "db9c4c3d-477c-4d5a-817b-318276713565"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "e50236ad-ad07-47d4-af71-ed7b52d200d5"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 ))
 *             ))
 *             .collectorName("fci-test0c1esqlsitecollector")
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/bansalankit-rg/providers/Microsoft.OffAzure/MasterSites/fci-ankit-test6065mastersite/SqlSites/fci-ankit-test6065sqlsites")
 *             .projectName("fci-test6904project")
 *             .resourceGroupName("rgmigrate")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:SqlCollectorOperation fci-test0c1esqlsitecollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/sqlcollectors/{collectorName}
 * ```
 */
public class SqlCollectorOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.SqlCollectorOperation,
) : KotlinCustomResource(javaResource, SqlCollectorOperationMapper) {
    /**
     * Gets or sets the collector agent properties.
     */
    public val agentProperties: Output<CollectorAgentPropertiesBaseResponse>?
        get() = javaResource.agentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> collectorAgentPropertiesBaseResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the Timestamp when collector was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the discovery site id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Timestamp when collector was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object SqlCollectorOperationMapper : ResourceMapper<SqlCollectorOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.SqlCollectorOperation::class == javaResource::class

    override fun map(javaResource: Resource): SqlCollectorOperation =
        SqlCollectorOperation(javaResource as com.pulumi.azurenative.migrate.SqlCollectorOperation)
}

/**
 * @see [SqlCollectorOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlCollectorOperation].
 */
public suspend fun sqlCollectorOperation(
    name: String,
    block: suspend SqlCollectorOperationResourceBuilder.() -> Unit,
): SqlCollectorOperation {
    val builder = SqlCollectorOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlCollectorOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlCollectorOperation(name: String): SqlCollectorOperation {
    val builder = SqlCollectorOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
