@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.AppSvcContainerSettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.AppSvcNativeSettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.DiscoveredEntityLightSummaryResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.EntityUptimeResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.AppSvcContainerSettingsResponse.Companion.toKotlin as appSvcContainerSettingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.AppSvcNativeSettingsResponse.Companion.toKotlin as appSvcNativeSettingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.DiscoveredEntityLightSummaryResponse.Companion.toKotlin as discoveredEntityLightSummaryResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.EntityUptimeResponse.Companion.toKotlin as entityUptimeResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WebAppAssessmentV2Operation].
 */
@PulumiTagMarker
public class WebAppAssessmentV2OperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppAssessmentV2OperationArgs = WebAppAssessmentV2OperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppAssessmentV2OperationArgsBuilder.() -> Unit) {
        val builder = WebAppAssessmentV2OperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppAssessmentV2Operation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.WebAppAssessmentV2Operation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppAssessmentV2Operation(builtJavaResource)
    }
}

/**
 * Web app Assessment REST resource.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### WebAppAssessmentV2Operations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppAssessmentV2Operation = new AzureNative.Migrate.WebAppAssessmentV2Operation("webAppAssessmentV2Operation", new()
 *     {
 *         AppSvcContainerSettings = new AzureNative.Migrate.Inputs.AppSvcContainerSettingsArgs
 *         {
 *             IsolationRequired = true,
 *         },
 *         AppSvcNativeSettings = new AzureNative.Migrate.Inputs.AppSvcNativeSettingsArgs
 *         {
 *             IsolationRequired = true,
 *         },
 *         AssessmentName = "anraghun-selfhost-v2",
 *         AssessmentType = "WebAppAssessment",
 *         AzureLocation = "UkWest",
 *         AzureOfferCode = "MSAZR0003P",
 *         AzureSecurityOfferingType = "NO",
 *         ConfidenceRatingInPercentage = 13,
 *         Currency = "USD",
 *         DiscountPercentage = 13,
 *         DiscoveredEntityLightSummary = new AzureNative.Migrate.Inputs.DiscoveredEntityLightSummaryArgs
 *         {
 *             NumberOfMachines = 27,
 *             NumberOfServers = 5,
 *             NumberOfWebApps = 23,
 *         },
 *         EaSubscriptionId = "",
 *         EntityUptime = new AzureNative.Migrate.Inputs.EntityUptimeArgs
 *         {
 *             DaysPerMonth = 18,
 *             HoursPerDay = 13,
 *         },
 *         EnvironmentType = "Production",
 *         GroupName = "anraghun-selfhost-v2",
 *         GroupType = "Default",
 *         Percentile = "Percentile50",
 *         PerfDataEndTime = "2023-11-03T05:42:45.496Z",
 *         PerfDataStartTime = "2023-11-03T05:42:45.496Z",
 *         ProjectName = "sumukk-ccy-bcs4557project",
 *         ReservedInstance = "None",
 *         ResourceGroupName = "rgopenapi",
 *         ScalingFactor = 17,
 *         SizingCriterion = "PerformanceBased",
 *         TimeRange = "Day",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWebAppAssessmentV2Operation(ctx, "webAppAssessmentV2Operation", &migrate.WebAppAssessmentV2OperationArgs{
 * 			AppSvcContainerSettings: &migrate.AppSvcContainerSettingsArgs{
 * 				IsolationRequired: pulumi.Bool(true),
 * 			},
 * 			AppSvcNativeSettings: &migrate.AppSvcNativeSettingsArgs{
 * 				IsolationRequired: pulumi.Bool(true),
 * 			},
 * 			AssessmentName:               pulumi.String("anraghun-selfhost-v2"),
 * 			AssessmentType:               pulumi.String("WebAppAssessment"),
 * 			AzureLocation:                pulumi.String("UkWest"),
 * 			AzureOfferCode:               pulumi.String("MSAZR0003P"),
 * 			AzureSecurityOfferingType:    pulumi.String("NO"),
 * 			ConfidenceRatingInPercentage: pulumi.Float64(13),
 * 			Currency:                     pulumi.String("USD"),
 * 			DiscountPercentage:           pulumi.Float64(13),
 * 			DiscoveredEntityLightSummary: &migrate.DiscoveredEntityLightSummaryArgs{
 * 				NumberOfMachines: pulumi.Int(27),
 * 				NumberOfServers:  pulumi.Int(5),
 * 				NumberOfWebApps:  pulumi.Int(23),
 * 			},
 * 			EaSubscriptionId: pulumi.String(""),
 * 			EntityUptime: &migrate.EntityUptimeArgs{
 * 				DaysPerMonth: pulumi.Int(18),
 * 				HoursPerDay:  pulumi.Int(13),
 * 			},
 * 			EnvironmentType:   pulumi.String("Production"),
 * 			GroupName:         pulumi.String("anraghun-selfhost-v2"),
 * 			GroupType:         pulumi.String("Default"),
 * 			Percentile:        pulumi.String("Percentile50"),
 * 			PerfDataEndTime:   pulumi.String("2023-11-03T05:42:45.496Z"),
 * 			PerfDataStartTime: pulumi.String("2023-11-03T05:42:45.496Z"),
 * 			ProjectName:       pulumi.String("sumukk-ccy-bcs4557project"),
 * 			ReservedInstance:  pulumi.String("None"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			ScalingFactor:     pulumi.Float64(17),
 * 			SizingCriterion:   pulumi.String("PerformanceBased"),
 * 			TimeRange:         pulumi.String("Day"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WebAppAssessmentV2Operation;
 * import com.pulumi.azurenative.migrate.WebAppAssessmentV2OperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppAssessmentV2Operation = new WebAppAssessmentV2Operation("webAppAssessmentV2Operation", WebAppAssessmentV2OperationArgs.builder()
 *             .appSvcContainerSettings(Map.of("isolationRequired", true))
 *             .appSvcNativeSettings(Map.of("isolationRequired", true))
 *             .assessmentName("anraghun-selfhost-v2")
 *             .assessmentType("WebAppAssessment")
 *             .azureLocation("UkWest")
 *             .azureOfferCode("MSAZR0003P")
 *             .azureSecurityOfferingType("NO")
 *             .confidenceRatingInPercentage(13)
 *             .currency("USD")
 *             .discountPercentage(13)
 *             .discoveredEntityLightSummary(Map.ofEntries(
 *                 Map.entry("numberOfMachines", 27),
 *                 Map.entry("numberOfServers", 5),
 *                 Map.entry("numberOfWebApps", 23)
 *             ))
 *             .eaSubscriptionId("")
 *             .entityUptime(Map.ofEntries(
 *                 Map.entry("daysPerMonth", 18),
 *                 Map.entry("hoursPerDay", 13)
 *             ))
 *             .environmentType("Production")
 *             .groupName("anraghun-selfhost-v2")
 *             .groupType("Default")
 *             .percentile("Percentile50")
 *             .perfDataEndTime("2023-11-03T05:42:45.496Z")
 *             .perfDataStartTime("2023-11-03T05:42:45.496Z")
 *             .projectName("sumukk-ccy-bcs4557project")
 *             .reservedInstance("None")
 *             .resourceGroupName("rgopenapi")
 *             .scalingFactor(17)
 *             .sizingCriterion("PerformanceBased")
 *             .timeRange("Day")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WebAppAssessmentV2Operation anraghun-v2-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/webAppAssessments/{assessmentName}
 * ```
 */
public class WebAppAssessmentV2Operation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.WebAppAssessmentV2Operation,
) : KotlinCustomResource(javaResource, WebAppAssessmentV2OperationMapper) {
    /**
     * Gets or sets user configurable app service container database settings.
     */
    public val appSvcContainerSettings: Output<AppSvcContainerSettingsResponse>?
        get() = javaResource.appSvcContainerSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appSvcContainerSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable app service native settings.
     */
    public val appSvcNativeSettings: Output<AppSvcNativeSettingsResponse>?
        get() = javaResource.appSvcNativeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appSvcNativeSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Assessment type of the assessment.
     */
    public val assessmentType: Output<String>?
        get() = javaResource.assessmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Location or Azure region where to which the machines will be migrated.
     */
    public val azureLocation: Output<String>?
        get() = javaResource.azureLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Offer Code.
     */
    public val azureOfferCode: Output<String>?
        get() = javaResource.azureOfferCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value indicating azure security offering type.
     */
    public val azureSecurityOfferingType: Output<String>?
        get() = javaResource.azureSecurityOfferingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Confidence Rating in Percentage.
     */
    public val confidenceRatingInPercentage: Output<Double>?
        get() = javaResource.confidenceRatingInPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and Time when assessment was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Currency in which prices should be reported.
     */
    public val currency: Output<String>?
        get() = javaResource.currency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Custom discount percentage.
     */
    public val discountPercentage: Output<Double>?
        get() = javaResource.discountPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable discovered entity settings.
     */
    public val discoveredEntityLightSummary: Output<DiscoveredEntityLightSummaryResponse>?
        get() = javaResource.discoveredEntityLightSummary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> discoveredEntityLightSummaryResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets the Enterprise agreement subscription id.
     */
    public val eaSubscriptionId: Output<String>?
        get() = javaResource.eaSubscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the duration for which the entity (Web app, VMs) are up in the
     * on-premises environment.
     */
    public val entityUptime: Output<EntityUptimeResponse>?
        get() = javaResource.entityUptime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    entityUptimeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable setting to display the environment type.
     */
    public val environmentType: Output<String>?
        get() = javaResource.environmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the group type for the assessment.
     */
    public val groupType: Output<String>?
        get() = javaResource.groupType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    public val percentile: Output<String>?
        get() = javaResource.percentile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the end time to consider performance data for assessment.
     */
    public val perfDataEndTime: Output<String>?
        get() = javaResource.perfDataEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the start time to consider performance data for assessment.
     */
    public val perfDataStartTime: Output<String>?
        get() = javaResource.perfDataStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time when rates were queried.
     */
    public val pricesTimestamp: Output<String>
        get() = javaResource.pricesTimestamp().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Reserved instance.
     */
    public val reservedInstance: Output<String>?
        get() = javaResource.reservedInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    public val scalingFactor: Output<Double>?
        get() = javaResource.scalingFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schema version.
     */
    public val schemaVersion: Output<String>
        get() = javaResource.schemaVersion().applyValue({ args0 -> args0 })

    /**
     * Assessment sizing criterion.
     */
    public val sizingCriterion: Output<String>?
        get() = javaResource.sizingCriterion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User configurable setting to display the Stage of Assessment.
     */
    public val stage: Output<String>
        get() = javaResource.stage().applyValue({ args0 -> args0 })

    /**
     * Whether assessment is in valid state and all machines have been assessed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    public val timeRange: Output<String>?
        get() = javaResource.timeRange().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Date and Time when assessment was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object WebAppAssessmentV2OperationMapper : ResourceMapper<WebAppAssessmentV2Operation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.WebAppAssessmentV2Operation::class == javaResource::class

    override fun map(javaResource: Resource): WebAppAssessmentV2Operation =
        WebAppAssessmentV2Operation(
            javaResource as
                com.pulumi.azurenative.migrate.WebAppAssessmentV2Operation,
        )
}

/**
 * @see [WebAppAssessmentV2Operation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppAssessmentV2Operation].
 */
public suspend fun webAppAssessmentV2Operation(
    name: String,
    block: suspend WebAppAssessmentV2OperationResourceBuilder.() -> Unit,
):
    WebAppAssessmentV2Operation {
    val builder = WebAppAssessmentV2OperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppAssessmentV2Operation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppAssessmentV2Operation(name: String): WebAppAssessmentV2Operation {
    val builder = WebAppAssessmentV2OperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
