@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.WebAppCollectorOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The web app collector REST object.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### WebAppCollectorOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppCollectorOperation = new AzureNative.Migrate.WebAppCollectorOperation("webAppCollectorOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "fed93df5-b787-4e3f-a764-e3d2b9101a59-agent",
 *             LastHeartbeatUtc = "2023-11-03T05:43:02.078Z",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *                 Audience = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *                 Authority = "https://login.microsoftonline.com/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *                 TenantId = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *             },
 *         },
 *         CollectorName = "collector1",
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sumukk-ccy-bcs/providers/Microsoft.OffAzure/MasterSites/sumukk-ccy-bcs9880mastersite/WebAppSites/sumukk-ccy-bcs9880webappsites",
 *         ProjectName = "sumukk-ccy-bcs4557project",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWebAppCollectorOperation(ctx, "webAppCollectorOperation", &migrate.WebAppCollectorOperationArgs{
 * 			AgentProperties: migrate.CollectorAgentPropertiesBaseResponse{
 * 				Id:               pulumi.String("fed93df5-b787-4e3f-a764-e3d2b9101a59-agent"),
 * 				LastHeartbeatUtc: pulumi.String("2023-11-03T05:43:02.078Z"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 					Audience:      pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 					Authority:     pulumi.String("https://login.microsoftonline.com/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 					TenantId:      pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 				},
 * 			},
 * 			CollectorName:     pulumi.String("collector1"),
 * 			DiscoverySiteId:   pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sumukk-ccy-bcs/providers/Microsoft.OffAzure/MasterSites/sumukk-ccy-bcs9880mastersite/WebAppSites/sumukk-ccy-bcs9880webappsites"),
 * 			ProjectName:       pulumi.String("sumukk-ccy-bcs4557project"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WebAppCollectorOperation;
 * import com.pulumi.azurenative.migrate.WebAppCollectorOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppCollectorOperation = new WebAppCollectorOperation("webAppCollectorOperation", WebAppCollectorOperationArgs.builder()
 *             .agentProperties(Map.ofEntries(
 *                 Map.entry("id", "fed93df5-b787-4e3f-a764-e3d2b9101a59-agent"),
 *                 Map.entry("lastHeartbeatUtc", "2023-11-03T05:43:02.078Z"),
 *                 Map.entry("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 *                     Map.entry("audience", "2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 *                     Map.entry("authority", "https://login.microsoftonline.com/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 *                     Map.entry("tenantId", "2f70d5e8-7adc-4c64-910a-7031079efc6e")
 *                 ))
 *             ))
 *             .collectorName("collector1")
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sumukk-ccy-bcs/providers/Microsoft.OffAzure/MasterSites/sumukk-ccy-bcs9880mastersite/WebAppSites/sumukk-ccy-bcs9880webappsites")
 *             .projectName("sumukk-ccy-bcs4557project")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WebAppCollectorOperation sumukk-ccy-bcs4a93webappsitecollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/webAppCollectors/{collectorName}
 * ```
 * @property agentProperties Gets or sets the collector agent properties.
 * @property collectorName Web app collector ARM name.
 * @property discoverySiteId Gets the discovery site id.
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class WebAppCollectorOperationArgs(
    public val agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null,
    public val collectorName: Output<String>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.WebAppCollectorOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.WebAppCollectorOperationArgs =
        com.pulumi.azurenative.migrate.WebAppCollectorOperationArgs.builder()
            .agentProperties(agentProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .collectorName(collectorName?.applyValue({ args0 -> args0 }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppCollectorOperationArgs].
 */
@PulumiTagMarker
public class WebAppCollectorOperationArgsBuilder internal constructor() {
    private var agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null

    private var collectorName: Output<String>? = null

    private var discoverySiteId: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("iayjwiycdvyiptga")
    public suspend fun agentProperties(`value`: Output<CollectorAgentPropertiesBaseArgs>) {
        this.agentProperties = value
    }

    /**
     * @param value Web app collector ARM name.
     */
    @JvmName("bbvucnfrooglkafv")
    public suspend fun collectorName(`value`: Output<String>) {
        this.collectorName = value
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("ukvbjhijmyqepaex")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("jbsjsmwqiwmghkaw")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qmywhsikdrhtxibw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("xujsnbqhtkcbtfcl")
    public suspend fun agentProperties(`value`: CollectorAgentPropertiesBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProperties = mapped
    }

    /**
     * @param argument Gets or sets the collector agent properties.
     */
    @JvmName("bdbtlakullcwclnm")
    public suspend
    fun agentProperties(argument: suspend CollectorAgentPropertiesBaseArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentPropertiesBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentProperties = mapped
    }

    /**
     * @param value Web app collector ARM name.
     */
    @JvmName("ibbdqsvaclglkvuu")
    public suspend fun collectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectorName = mapped
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("twcghnndoaxrixgg")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("fcxpknfgbyrcayun")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("utjdwpgojvaxmnyo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppCollectorOperationArgs = WebAppCollectorOperationArgs(
        agentProperties = agentProperties,
        collectorName = collectorName,
        discoverySiteId = discoverySiteId,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
    )
}
