@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets environment type.
 */
public enum class AzureEnvironmentType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.AzureEnvironmentType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.AzureEnvironmentType> {
    /**
     * Unknown. Indicates missing data.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.AzureEnvironmentType.Unknown),

    /**
     * Development or Test Environment.
     */
    DevTest(com.pulumi.azurenative.migrate.enums.AzureEnvironmentType.DevTest),

    /**
     * Production Environment.
     */
    Production(com.pulumi.azurenative.migrate.enums.AzureEnvironmentType.Production),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.AzureEnvironmentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.AzureEnvironmentType):
            AzureEnvironmentType = AzureEnvironmentType.values().first { it.javaValue == javaType }
    }
}
