@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets consolidation type.
 */
public enum class ConsolidationType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.ConsolidationType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.ConsolidationType> {
    /**
     * Full Consolidation.
     */
    Full(com.pulumi.azurenative.migrate.enums.ConsolidationType.Full),

    /**
     * As On Source or On Premises Consolidation.
     */
    AsOnSource(com.pulumi.azurenative.migrate.enums.ConsolidationType.AsOnSource),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.ConsolidationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.ConsolidationType):
            ConsolidationType = ConsolidationType.values().first { it.javaValue == javaType }
    }
}
