@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets pricing tier.
 */
public enum class PricingTier(
    public val javaValue: com.pulumi.azurenative.migrate.enums.PricingTier,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.PricingTier> {
    /**
     * Standard Pricing Tier.
     */
    Standard(com.pulumi.azurenative.migrate.enums.PricingTier.Standard),

    /**
     * Free Pricing Tier.
     */
    Free(com.pulumi.azurenative.migrate.enums.PricingTier.Free),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.PricingTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.PricingTier): PricingTier =
            PricingTier.values().first { it.javaValue == javaType }
    }
}
