@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the current status of the solution.
 */
public enum class Status(
    public val javaValue: com.pulumi.azurenative.migrate.enums.Status,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.Status> {
    Inactive(com.pulumi.azurenative.migrate.enums.Status.Inactive),
    Active(com.pulumi.azurenative.migrate.enums.Status.Active),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.Status = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.Status): Status =
            Status.values().first { it.javaValue == javaType }
    }
}
