@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the storage provider type on the target.
 * Applicable when StorageProjectionType is not ContainerFileSystem.
 */
public enum class TargetHydrationStorageProviderType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.TargetHydrationStorageProviderType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.TargetHydrationStorageProviderType> {
    AzureFileShare(com.pulumi.azurenative.migrate.enums.TargetHydrationStorageProviderType.AzureFileShare),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.TargetHydrationStorageProviderType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.TargetHydrationStorageProviderType):
            TargetHydrationStorageProviderType =
            TargetHydrationStorageProviderType.values().first { it.javaValue == javaType }
    }
}
