@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AKSAssessmentSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentSizingCriterion
import com.pulumi.azurenative.migrate.kotlin.enums.AzureCurrency
import com.pulumi.azurenative.migrate.kotlin.enums.AzureEnvironmentType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureVmCategory
import com.pulumi.azurenative.migrate.kotlin.enums.ConsolidationType
import com.pulumi.azurenative.migrate.kotlin.enums.LicensingProgram
import com.pulumi.azurenative.migrate.kotlin.enums.PricingTier
import com.pulumi.azurenative.migrate.kotlin.enums.SavingsOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Data model of AKS Assessment Settings.
 * @property azureLocation Gets or sets azure location.
 * @property category Gets or sets azure VM category.
 * @property consolidation Gets or sets consolidation type.
 * @property currency Gets or sets currency.
 * @property discountPercentage Gets or sets discount percentage.
 * @property environmentType Gets or sets environment type.
 * @property licensingProgram Gets or sets licensing program.
 * @property performanceData Gets or sets performance data settings.
 * @property pricingTier Gets or sets pricing tier.
 * @property savingsOptions Gets or sets savings options.
 * @property scalingFactor Gets or sets scaling factor.
 * @property sizingCriteria Gets or sets sizing criteria.
 */
public data class AKSAssessmentSettingsArgs(
    public val azureLocation: Output<String>,
    public val category: Output<Either<String, AzureVmCategory>>,
    public val consolidation: Output<Either<String, ConsolidationType>>,
    public val currency: Output<Either<String, AzureCurrency>>,
    public val discountPercentage: Output<Double>? = null,
    public val environmentType: Output<Either<String, AzureEnvironmentType>>,
    public val licensingProgram: Output<Either<String, LicensingProgram>>,
    public val performanceData: Output<PerfDataSettingsArgs>? = null,
    public val pricingTier: Output<Either<String, PricingTier>>,
    public val savingsOptions: Output<Either<String, SavingsOptions>>,
    public val scalingFactor: Output<Double>? = null,
    public val sizingCriteria: Output<Either<String, AssessmentSizingCriterion>>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AKSAssessmentSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AKSAssessmentSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.AKSAssessmentSettingsArgs.builder()
            .azureLocation(azureLocation.applyValue({ args0 -> args0 }))
            .category(
                category.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .consolidation(
                consolidation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .currency(
                currency.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .discountPercentage(discountPercentage?.applyValue({ args0 -> args0 }))
            .environmentType(
                environmentType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .licensingProgram(
                licensingProgram.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .performanceData(performanceData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pricingTier(
                pricingTier.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .savingsOptions(
                savingsOptions.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scalingFactor(scalingFactor?.applyValue({ args0 -> args0 }))
            .sizingCriteria(
                sizingCriteria.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AKSAssessmentSettingsArgs].
 */
@PulumiTagMarker
public class AKSAssessmentSettingsArgsBuilder internal constructor() {
    private var azureLocation: Output<String>? = null

    private var category: Output<Either<String, AzureVmCategory>>? = null

    private var consolidation: Output<Either<String, ConsolidationType>>? = null

    private var currency: Output<Either<String, AzureCurrency>>? = null

    private var discountPercentage: Output<Double>? = null

    private var environmentType: Output<Either<String, AzureEnvironmentType>>? = null

    private var licensingProgram: Output<Either<String, LicensingProgram>>? = null

    private var performanceData: Output<PerfDataSettingsArgs>? = null

    private var pricingTier: Output<Either<String, PricingTier>>? = null

    private var savingsOptions: Output<Either<String, SavingsOptions>>? = null

    private var scalingFactor: Output<Double>? = null

    private var sizingCriteria: Output<Either<String, AssessmentSizingCriterion>>? = null

    /**
     * @param value Gets or sets azure location.
     */
    @JvmName("oaxgnxnhbnkfuvvg")
    public suspend fun azureLocation(`value`: Output<String>) {
        this.azureLocation = value
    }

    /**
     * @param value Gets or sets azure VM category.
     */
    @JvmName("crhesdtrynohaljk")
    public suspend fun category(`value`: Output<Either<String, AzureVmCategory>>) {
        this.category = value
    }

    /**
     * @param value Gets or sets consolidation type.
     */
    @JvmName("racvxrpbumryiuyu")
    public suspend fun consolidation(`value`: Output<Either<String, ConsolidationType>>) {
        this.consolidation = value
    }

    /**
     * @param value Gets or sets currency.
     */
    @JvmName("jdjswxevkkwhftxv")
    public suspend fun currency(`value`: Output<Either<String, AzureCurrency>>) {
        this.currency = value
    }

    /**
     * @param value Gets or sets discount percentage.
     */
    @JvmName("wjyfbpjwgepuvhei")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Gets or sets environment type.
     */
    @JvmName("fxqjguxjbbanpant")
    public suspend fun environmentType(`value`: Output<Either<String, AzureEnvironmentType>>) {
        this.environmentType = value
    }

    /**
     * @param value Gets or sets licensing program.
     */
    @JvmName("bqrowvkonyscplsf")
    public suspend fun licensingProgram(`value`: Output<Either<String, LicensingProgram>>) {
        this.licensingProgram = value
    }

    /**
     * @param value Gets or sets performance data settings.
     */
    @JvmName("qpjbchhhytxfsmvv")
    public suspend fun performanceData(`value`: Output<PerfDataSettingsArgs>) {
        this.performanceData = value
    }

    /**
     * @param value Gets or sets pricing tier.
     */
    @JvmName("huasjawkknswhcjp")
    public suspend fun pricingTier(`value`: Output<Either<String, PricingTier>>) {
        this.pricingTier = value
    }

    /**
     * @param value Gets or sets savings options.
     */
    @JvmName("bxcobmbcxmdbltwv")
    public suspend fun savingsOptions(`value`: Output<Either<String, SavingsOptions>>) {
        this.savingsOptions = value
    }

    /**
     * @param value Gets or sets scaling factor.
     */
    @JvmName("ejsjdcvvleyytmfv")
    public suspend fun scalingFactor(`value`: Output<Double>) {
        this.scalingFactor = value
    }

    /**
     * @param value Gets or sets sizing criteria.
     */
    @JvmName("ksmxuuqogcrwfkdp")
    public suspend fun sizingCriteria(`value`: Output<Either<String, AssessmentSizingCriterion>>) {
        this.sizingCriteria = value
    }

    /**
     * @param value Gets or sets azure location.
     */
    @JvmName("pypohhooutrqcyrt")
    public suspend fun azureLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Gets or sets azure VM category.
     */
    @JvmName("vopfanyowwjsjhry")
    public suspend fun category(`value`: Either<String, AzureVmCategory>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Gets or sets azure VM category.
     */
    @JvmName("giastaascllqidre")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureVmCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Gets or sets azure VM category.
     */
    @JvmName("kmmngiogivfsoijx")
    public fun category(`value`: AzureVmCategory) {
        val toBeMapped = Either.ofRight<String, AzureVmCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Gets or sets consolidation type.
     */
    @JvmName("faqibxgfyhpxkxao")
    public suspend fun consolidation(`value`: Either<String, ConsolidationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consolidation = mapped
    }

    /**
     * @param value Gets or sets consolidation type.
     */
    @JvmName("mcfhsxjquqvcjpux")
    public fun consolidation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConsolidationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consolidation = mapped
    }

    /**
     * @param value Gets or sets consolidation type.
     */
    @JvmName("ftapflfinmahenen")
    public fun consolidation(`value`: ConsolidationType) {
        val toBeMapped = Either.ofRight<String, ConsolidationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consolidation = mapped
    }

    /**
     * @param value Gets or sets currency.
     */
    @JvmName("pppkyljqixyycahw")
    public suspend fun currency(`value`: Either<String, AzureCurrency>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Gets or sets currency.
     */
    @JvmName("wolujdiqetogsefk")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Gets or sets currency.
     */
    @JvmName("nlxpbokypirimvrq")
    public fun currency(`value`: AzureCurrency) {
        val toBeMapped = Either.ofRight<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Gets or sets discount percentage.
     */
    @JvmName("nvnqhmdgsugnhfvc")
    public suspend fun discountPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Gets or sets environment type.
     */
    @JvmName("mwnnwhxanyqlsjio")
    public suspend fun environmentType(`value`: Either<String, AzureEnvironmentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets environment type.
     */
    @JvmName("bgpfytjqrqdyryjo")
    public fun environmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets environment type.
     */
    @JvmName("mxyloriwvutphacd")
    public fun environmentType(`value`: AzureEnvironmentType) {
        val toBeMapped = Either.ofRight<String, AzureEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets licensing program.
     */
    @JvmName("pglmrrcbcitctker")
    public suspend fun licensingProgram(`value`: Either<String, LicensingProgram>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licensingProgram = mapped
    }

    /**
     * @param value Gets or sets licensing program.
     */
    @JvmName("kuumpscvthinpary")
    public fun licensingProgram(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicensingProgram>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licensingProgram = mapped
    }

    /**
     * @param value Gets or sets licensing program.
     */
    @JvmName("qcjklqpwujubbprl")
    public fun licensingProgram(`value`: LicensingProgram) {
        val toBeMapped = Either.ofRight<String, LicensingProgram>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licensingProgram = mapped
    }

    /**
     * @param value Gets or sets performance data settings.
     */
    @JvmName("xxpqjfqxuvijpftc")
    public suspend fun performanceData(`value`: PerfDataSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceData = mapped
    }

    /**
     * @param argument Gets or sets performance data settings.
     */
    @JvmName("qsgjxatlwflqxqjk")
    public suspend fun performanceData(argument: suspend PerfDataSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PerfDataSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.performanceData = mapped
    }

    /**
     * @param value Gets or sets pricing tier.
     */
    @JvmName("rneemsvbguawvtwx")
    public suspend fun pricingTier(`value`: Either<String, PricingTier>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pricingTier = mapped
    }

    /**
     * @param value Gets or sets pricing tier.
     */
    @JvmName("eftbfeucwlvtdksq")
    public fun pricingTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pricingTier = mapped
    }

    /**
     * @param value Gets or sets pricing tier.
     */
    @JvmName("iisfhdapydxukfqy")
    public fun pricingTier(`value`: PricingTier) {
        val toBeMapped = Either.ofRight<String, PricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pricingTier = mapped
    }

    /**
     * @param value Gets or sets savings options.
     */
    @JvmName("meywssshmxgviyxt")
    public suspend fun savingsOptions(`value`: Either<String, SavingsOptions>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.savingsOptions = mapped
    }

    /**
     * @param value Gets or sets savings options.
     */
    @JvmName("vamrgkbmlagujjfw")
    public fun savingsOptions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SavingsOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.savingsOptions = mapped
    }

    /**
     * @param value Gets or sets savings options.
     */
    @JvmName("wbwndcnihvxfemvk")
    public fun savingsOptions(`value`: SavingsOptions) {
        val toBeMapped = Either.ofRight<String, SavingsOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.savingsOptions = mapped
    }

    /**
     * @param value Gets or sets scaling factor.
     */
    @JvmName("qjfikfojnlvscfsb")
    public suspend fun scalingFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingFactor = mapped
    }

    /**
     * @param value Gets or sets sizing criteria.
     */
    @JvmName("mhtwvcigbqxtsaww")
    public suspend fun sizingCriteria(`value`: Either<String, AssessmentSizingCriterion>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriteria = mapped
    }

    /**
     * @param value Gets or sets sizing criteria.
     */
    @JvmName("ddicyrjxntenqspj")
    public fun sizingCriteria(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriteria = mapped
    }

    /**
     * @param value Gets or sets sizing criteria.
     */
    @JvmName("scalmjxyjrgylomd")
    public fun sizingCriteria(`value`: AssessmentSizingCriterion) {
        val toBeMapped = Either.ofRight<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriteria = mapped
    }

    internal fun build(): AKSAssessmentSettingsArgs = AKSAssessmentSettingsArgs(
        azureLocation = azureLocation ?: throw PulumiNullFieldException("azureLocation"),
        category = category ?: throw PulumiNullFieldException("category"),
        consolidation = consolidation ?: throw PulumiNullFieldException("consolidation"),
        currency = currency ?: throw PulumiNullFieldException("currency"),
        discountPercentage = discountPercentage,
        environmentType = environmentType ?: throw PulumiNullFieldException("environmentType"),
        licensingProgram = licensingProgram ?: throw PulumiNullFieldException("licensingProgram"),
        performanceData = performanceData,
        pricingTier = pricingTier ?: throw PulumiNullFieldException("pricingTier"),
        savingsOptions = savingsOptions ?: throw PulumiNullFieldException("savingsOptions"),
        scalingFactor = scalingFactor,
        sizingCriteria = sizingCriteria ?: throw PulumiNullFieldException("sizingCriteria"),
    )
}
