@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AKSDeploymentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class for AKSDeployment Properties.
 * @property aksClusterName Gets or sets the AKS cluster name.
 * @property resourceGroup Gets or sets the resource group of the resource.
 * @property subscriptionId Gets or sets the subscription id of the resource.
 * @property tenantId Gets or sets the tenant id.
 */
public data class AKSDeploymentPropertiesArgs(
    public val aksClusterName: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AKSDeploymentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AKSDeploymentPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.AKSDeploymentPropertiesArgs.builder()
            .aksClusterName(aksClusterName?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AKSDeploymentPropertiesArgs].
 */
@PulumiTagMarker
public class AKSDeploymentPropertiesArgsBuilder internal constructor() {
    private var aksClusterName: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Gets or sets the AKS cluster name.
     */
    @JvmName("ijejkakxwrrdierp")
    public suspend fun aksClusterName(`value`: Output<String>) {
        this.aksClusterName = value
    }

    /**
     * @param value Gets or sets the resource group of the resource.
     */
    @JvmName("ypcntnoahnqxknkr")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Gets or sets the subscription id of the resource.
     */
    @JvmName("ldqyofyeqwjqtrrm")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the tenant id.
     */
    @JvmName("kpwicmjngrgixwya")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Gets or sets the AKS cluster name.
     */
    @JvmName("erhwkfmqyutfssqt")
    public suspend fun aksClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aksClusterName = mapped
    }

    /**
     * @param value Gets or sets the resource group of the resource.
     */
    @JvmName("fdjdfuqptitbhvsv")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Gets or sets the subscription id of the resource.
     */
    @JvmName("vaftrqgjvpotfwby")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Gets or sets the tenant id.
     */
    @JvmName("hccufpaanqwxcnpr")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AKSDeploymentPropertiesArgs = AKSDeploymentPropertiesArgs(
        aksClusterName = aksClusterName,
        resourceGroup = resourceGroup,
        subscriptionId = subscriptionId,
        tenantId = tenantId,
    )
}
