@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AKSDeploymentSpecificationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.LoadBalancerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AKS Deployment Specification.
 * @property kubernetesObjectsYaml Gets or sets the Merged Deployment and service Yaml.
 * @property loadBalancerType Gets or sets the load balancer type.
 * @property replicaCount Gets or sets the replica count to be created in AKS.
 */
public data class AKSDeploymentSpecificationArgs(
    public val kubernetesObjectsYaml: Output<String>? = null,
    public val loadBalancerType: Output<Either<String, LoadBalancerType>>? = null,
    public val replicaCount: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AKSDeploymentSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AKSDeploymentSpecificationArgs =
        com.pulumi.azurenative.migrate.inputs.AKSDeploymentSpecificationArgs.builder()
            .kubernetesObjectsYaml(kubernetesObjectsYaml?.applyValue({ args0 -> args0 }))
            .loadBalancerType(
                loadBalancerType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .replicaCount(replicaCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AKSDeploymentSpecificationArgs].
 */
@PulumiTagMarker
public class AKSDeploymentSpecificationArgsBuilder internal constructor() {
    private var kubernetesObjectsYaml: Output<String>? = null

    private var loadBalancerType: Output<Either<String, LoadBalancerType>>? = null

    private var replicaCount: Output<String>? = null

    /**
     * @param value Gets or sets the Merged Deployment and service Yaml.
     */
    @JvmName("dexsjaloaskwvxqq")
    public suspend fun kubernetesObjectsYaml(`value`: Output<String>) {
        this.kubernetesObjectsYaml = value
    }

    /**
     * @param value Gets or sets the load balancer type.
     */
    @JvmName("dnrsnjfmlfqgwspn")
    public suspend fun loadBalancerType(`value`: Output<Either<String, LoadBalancerType>>) {
        this.loadBalancerType = value
    }

    /**
     * @param value Gets or sets the replica count to be created in AKS.
     */
    @JvmName("nsktfdtddtpoiccc")
    public suspend fun replicaCount(`value`: Output<String>) {
        this.replicaCount = value
    }

    /**
     * @param value Gets or sets the Merged Deployment and service Yaml.
     */
    @JvmName("maiyaeelalrafauy")
    public suspend fun kubernetesObjectsYaml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesObjectsYaml = mapped
    }

    /**
     * @param value Gets or sets the load balancer type.
     */
    @JvmName("kkqjkmlylalhhhsx")
    public suspend fun loadBalancerType(`value`: Either<String, LoadBalancerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Gets or sets the load balancer type.
     */
    @JvmName("elsqvnexywtyqbeu")
    public fun loadBalancerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Gets or sets the load balancer type.
     */
    @JvmName("wkwtqpunykhbiwon")
    public fun loadBalancerType(`value`: LoadBalancerType) {
        val toBeMapped = Either.ofRight<String, LoadBalancerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Gets or sets the replica count to be created in AKS.
     */
    @JvmName("avgxdbrxncpdsupv")
    public suspend fun replicaCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCount = mapped
    }

    internal fun build(): AKSDeploymentSpecificationArgs = AKSDeploymentSpecificationArgs(
        kubernetesObjectsYaml = kubernetesObjectsYaml,
        loadBalancerType = loadBalancerType,
        replicaCount = replicaCount,
    )
}
