@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ApacheTomcat workload instance model custom properties.
 * @property apacheTomcatAksWorkloadDeploymentProperties ApacheTomcat web application.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
 */
public data class ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs(
    public val apacheTomcatAksWorkloadDeploymentProperties:
    Output<ApacheTomcatAKSWorkloadDeploymentArgs>? = null,
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs.builder()
            .apacheTomcatAksWorkloadDeploymentProperties(
                apacheTomcatAksWorkloadDeploymentProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgsBuilder internal
constructor() {
    private var apacheTomcatAksWorkloadDeploymentProperties:
        Output<ApacheTomcatAKSWorkloadDeploymentArgs>? = null

    private var instanceType: Output<String>? = null

    /**
     * @param value ApacheTomcat web application.
     */
    @JvmName("eslymmwpsmjgmsaf")
    public suspend
    fun apacheTomcatAksWorkloadDeploymentProperties(`value`: Output<ApacheTomcatAKSWorkloadDeploymentArgs>) {
        this.apacheTomcatAksWorkloadDeploymentProperties = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
     */
    @JvmName("bwuyxxqadyihgtvo")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value ApacheTomcat web application.
     */
    @JvmName("pmscnhdfhkibmbxl")
    public suspend
    fun apacheTomcatAksWorkloadDeploymentProperties(`value`: ApacheTomcatAKSWorkloadDeploymentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apacheTomcatAksWorkloadDeploymentProperties = mapped
    }

    /**
     * @param argument ApacheTomcat web application.
     */
    @JvmName("sromdfetiykpshrh")
    public suspend
    fun apacheTomcatAksWorkloadDeploymentProperties(argument: suspend ApacheTomcatAKSWorkloadDeploymentArgsBuilder.() -> Unit) {
        val toBeMapped = ApacheTomcatAKSWorkloadDeploymentArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.apacheTomcatAksWorkloadDeploymentProperties = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
     */
    @JvmName("ewvskgexsbhetitw")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs =
        ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs(
            apacheTomcatAksWorkloadDeploymentProperties = apacheTomcatAksWorkloadDeploymentProperties,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        )
}
