@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ApacheTomcat web application.
 * @property applicationId Gets or sets the web application id.
 * @property applicationName Gets or sets the web application name.
 * @property applicationScratchPath Gets or sets application scratch path.
 * @property bindings Gets or sets the bindings for the application.
 * @property configurations Gets or sets application configuration.
 * @property directories Gets or sets application directories.
 * @property discoveredFrameworks Gets or sets the discovered frameworks of application.
 * @property displayName Gets or sets the display name.
 * @property limits Resource Requirements.
 * @property path Second level entity for virtual directories.
 * @property primaryFramework Framework specific data for a web application.
 * @property requests Resource Requirements.
 * @property webServerId Gets or sets the web server id.
 * @property webServerName Gets or sets the web server name.
 */
public data class ApacheTomcatWebApplicationArgs(
    public val applicationId: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val applicationScratchPath: Output<String>? = null,
    public val bindings: Output<List<BindingArgs>>? = null,
    public val configurations: Output<List<WebApplicationConfigurationArgs>>? = null,
    public val directories: Output<List<WebApplicationDirectoryArgs>>? = null,
    public val discoveredFrameworks: Output<List<WebApplicationFrameworkArgs>>? = null,
    public val displayName: Output<String>? = null,
    public val limits: Output<ResourceRequirementsArgs>? = null,
    public val path: Output<DirectoryPathArgs>? = null,
    public val primaryFramework: Output<WebApplicationFrameworkArgs>? = null,
    public val requests: Output<ResourceRequirementsArgs>? = null,
    public val webServerId: Output<String>? = null,
    public val webServerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs =
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .applicationScratchPath(applicationScratchPath?.applyValue({ args0 -> args0 }))
            .bindings(
                bindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .directories(
                directories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .discoveredFrameworks(
                discoveredFrameworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryFramework(primaryFramework?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requests(requests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webServerId(webServerId?.applyValue({ args0 -> args0 }))
            .webServerName(webServerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApacheTomcatWebApplicationArgs].
 */
@PulumiTagMarker
public class ApacheTomcatWebApplicationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var applicationScratchPath: Output<String>? = null

    private var bindings: Output<List<BindingArgs>>? = null

    private var configurations: Output<List<WebApplicationConfigurationArgs>>? = null

    private var directories: Output<List<WebApplicationDirectoryArgs>>? = null

    private var discoveredFrameworks: Output<List<WebApplicationFrameworkArgs>>? = null

    private var displayName: Output<String>? = null

    private var limits: Output<ResourceRequirementsArgs>? = null

    private var path: Output<DirectoryPathArgs>? = null

    private var primaryFramework: Output<WebApplicationFrameworkArgs>? = null

    private var requests: Output<ResourceRequirementsArgs>? = null

    private var webServerId: Output<String>? = null

    private var webServerName: Output<String>? = null

    /**
     * @param value Gets or sets the web application id.
     */
    @JvmName("geodxxfqvlyhyyix")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Gets or sets the web application name.
     */
    @JvmName("wnmqaljmlipkattf")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Gets or sets application scratch path.
     */
    @JvmName("ayebbvqlwtyxthog")
    public suspend fun applicationScratchPath(`value`: Output<String>) {
        this.applicationScratchPath = value
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("cdkeitxfgqxpuvjd")
    public suspend fun bindings(`value`: Output<List<BindingArgs>>) {
        this.bindings = value
    }

    @JvmName("qvpguyjygdhgenwe")
    public suspend fun bindings(vararg values: Output<BindingArgs>) {
        this.bindings = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("byncwqhjkwcpiijq")
    public suspend fun bindings(values: List<Output<BindingArgs>>) {
        this.bindings = Output.all(values)
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("cospufbyiloldjfs")
    public suspend fun configurations(`value`: Output<List<WebApplicationConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("ulbqrhmtkjyxanah")
    public suspend fun configurations(vararg values: Output<WebApplicationConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("qabxedwgmsvpqcqs")
    public suspend fun configurations(values: List<Output<WebApplicationConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("nhwqmkjuffasdowj")
    public suspend fun directories(`value`: Output<List<WebApplicationDirectoryArgs>>) {
        this.directories = value
    }

    @JvmName("dorpbsvayvcuecaf")
    public suspend fun directories(vararg values: Output<WebApplicationDirectoryArgs>) {
        this.directories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("brsklbjavhdyckfu")
    public suspend fun directories(values: List<Output<WebApplicationDirectoryArgs>>) {
        this.directories = Output.all(values)
    }

    /**
     * @param value Gets or sets the discovered frameworks of application.
     */
    @JvmName("qtkyejlutdcwfqta")
    public suspend fun discoveredFrameworks(`value`: Output<List<WebApplicationFrameworkArgs>>) {
        this.discoveredFrameworks = value
    }

    @JvmName("yodfbyfanmcbxmux")
    public suspend fun discoveredFrameworks(vararg values: Output<WebApplicationFrameworkArgs>) {
        this.discoveredFrameworks = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the discovered frameworks of application.
     */
    @JvmName("xlhgdbwkxamwcrbs")
    public suspend fun discoveredFrameworks(values: List<Output<WebApplicationFrameworkArgs>>) {
        this.discoveredFrameworks = Output.all(values)
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("ktmosirucibibtfa")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("nnmbkdshpmxejnyr")
    public suspend fun limits(`value`: Output<ResourceRequirementsArgs>) {
        this.limits = value
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("wurfuqvkflwaxduv")
    public suspend fun path(`value`: Output<DirectoryPathArgs>) {
        this.path = value
    }

    /**
     * @param value Framework specific data for a web application.
     */
    @JvmName("lrkvhncivfbsyqut")
    public suspend fun primaryFramework(`value`: Output<WebApplicationFrameworkArgs>) {
        this.primaryFramework = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("plgcjvrekkgoclhq")
    public suspend fun requests(`value`: Output<ResourceRequirementsArgs>) {
        this.requests = value
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("dpcdlxhybtgaquqa")
    public suspend fun webServerId(`value`: Output<String>) {
        this.webServerId = value
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("cdhmgvsssenvhfwv")
    public suspend fun webServerName(`value`: Output<String>) {
        this.webServerName = value
    }

    /**
     * @param value Gets or sets the web application id.
     */
    @JvmName("slqkppwivaedihla")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Gets or sets the web application name.
     */
    @JvmName("qqwsmwsildiyiyru")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Gets or sets application scratch path.
     */
    @JvmName("xvdidpftgenwmeat")
    public suspend fun applicationScratchPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationScratchPath = mapped
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("lhcberjcfuuqurpk")
    public suspend fun bindings(`value`: List<BindingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("lebtrwtvadvcrcxe")
    public suspend fun bindings(argument: List<suspend BindingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("dnvknlbycdippwno")
    public suspend fun bindings(vararg argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("tfouceyieabqbfbv")
    public suspend fun bindings(argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BindingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("udsrvqouafoodrik")
    public suspend fun bindings(vararg values: BindingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("twdlwavdekebfoex")
    public suspend fun configurations(`value`: List<WebApplicationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("lqcoasftpjedctpi")
    public suspend
    fun configurations(argument: List<suspend WebApplicationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("ouqvbvwvmyorqeal")
    public suspend fun configurations(
        vararg
        argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("brivrahsccdeeqmj")
    public suspend
    fun configurations(argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("vpdtnirutirwrgit")
    public suspend fun configurations(vararg values: WebApplicationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("vkejdorfbbppoiic")
    public suspend fun directories(`value`: List<WebApplicationDirectoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("rrwbeubyxuiawwkm")
    public suspend
    fun directories(argument: List<suspend WebApplicationDirectoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("bgpifvrmbafijehm")
    public suspend fun directories(
        vararg
        argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("vqnimgrmrjdtmjql")
    public suspend fun directories(argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationDirectoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("gswwjiwaqoyeebri")
    public suspend fun directories(vararg values: WebApplicationDirectoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param value Gets or sets the discovered frameworks of application.
     */
    @JvmName("osxpnhijgiwirvgr")
    public suspend fun discoveredFrameworks(`value`: List<WebApplicationFrameworkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("nydvbvvnxwnrobvr")
    public suspend
    fun discoveredFrameworks(argument: List<suspend WebApplicationFrameworkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationFrameworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("kfqtcauejvwglqrn")
    public suspend fun discoveredFrameworks(
        vararg
        argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationFrameworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("nqtpaiqvxbydwnxu")
    public suspend
    fun discoveredFrameworks(argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationFrameworkArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param values Gets or sets the discovered frameworks of application.
     */
    @JvmName("dnfpvwmjiebkpvvi")
    public suspend fun discoveredFrameworks(vararg values: WebApplicationFrameworkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveredFrameworks = mapped
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("fjuqvpwlkthltgbw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("hdrpxficgvnooreb")
    public suspend fun limits(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("rperwuvbkusoriuh")
    public suspend fun limits(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("swxyiadfhestbran")
    public suspend fun path(`value`: DirectoryPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Second level entity for virtual directories.
     */
    @JvmName("bgxqjlegrgoccjxa")
    public suspend fun path(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value Framework specific data for a web application.
     */
    @JvmName("gukfhpjqgwlfnmpn")
    public suspend fun primaryFramework(`value`: WebApplicationFrameworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFramework = mapped
    }

    /**
     * @param argument Framework specific data for a web application.
     */
    @JvmName("nfwkbpqawtcuepsm")
    public suspend
    fun primaryFramework(argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = WebApplicationFrameworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryFramework = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("uvgdtfprakuwdjej")
    public suspend fun requests(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("dbjcwjhwvcsopvce")
    public suspend fun requests(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("gugovbhhictogkpb")
    public suspend fun webServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerId = mapped
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("rytpiqmrrucfsbdr")
    public suspend fun webServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerName = mapped
    }

    internal fun build(): ApacheTomcatWebApplicationArgs = ApacheTomcatWebApplicationArgs(
        applicationId = applicationId,
        applicationName = applicationName,
        applicationScratchPath = applicationScratchPath,
        bindings = bindings,
        configurations = configurations,
        directories = directories,
        discoveredFrameworks = discoveredFrameworks,
        displayName = displayName,
        limits = limits,
        path = path,
        primaryFramework = primaryFramework,
        requests = requests,
        webServerId = webServerId,
        webServerName = webServerName,
    )
}
