@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AppSvcNativeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * App service native settings.
 * @property isolationRequired Gets or sets the isolation required.
 */
public data class AppSvcNativeSettingsArgs(
    public val isolationRequired: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AppSvcNativeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AppSvcNativeSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.AppSvcNativeSettingsArgs.builder()
            .isolationRequired(isolationRequired.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppSvcNativeSettingsArgs].
 */
@PulumiTagMarker
public class AppSvcNativeSettingsArgsBuilder internal constructor() {
    private var isolationRequired: Output<Boolean>? = null

    /**
     * @param value Gets or sets the isolation required.
     */
    @JvmName("ortucrkbevdjdqad")
    public suspend fun isolationRequired(`value`: Output<Boolean>) {
        this.isolationRequired = value
    }

    /**
     * @param value Gets or sets the isolation required.
     */
    @JvmName("qnpdhlgskqtvmhdo")
    public suspend fun isolationRequired(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isolationRequired = mapped
    }

    internal fun build(): AppSvcNativeSettingsArgs = AppSvcNativeSettingsArgs(
        isolationRequired = isolationRequired ?: throw PulumiNullFieldException("isolationRequired"),
    )
}
