@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.BindingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Binding for a web application.
 * @property cert WebApplication certificate.
 * @property hostName Gets or sets the binding host name.
 * @property ipAddress Gets or sets the IP Address.
 * @property port Gets or sets the application port.
 * @property portMapping WebApplication port mapping.
 * @property protocol Gets or sets the protocol.
 */
public data class BindingArgs(
    public val cert: Output<CertArgs>? = null,
    public val hostName: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val port: Output<String>? = null,
    public val portMapping: Output<PortMappingArgs>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.BindingArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.BindingArgs =
        com.pulumi.azurenative.migrate.inputs.BindingArgs.builder()
            .cert(cert?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .portMapping(portMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BindingArgs].
 */
@PulumiTagMarker
public class BindingArgsBuilder internal constructor() {
    private var cert: Output<CertArgs>? = null

    private var hostName: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var port: Output<String>? = null

    private var portMapping: Output<PortMappingArgs>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value WebApplication certificate.
     */
    @JvmName("nqhpdnioiscepbjc")
    public suspend fun cert(`value`: Output<CertArgs>) {
        this.cert = value
    }

    /**
     * @param value Gets or sets the binding host name.
     */
    @JvmName("aemrgumancuglway")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Gets or sets the IP Address.
     */
    @JvmName("imuftdjylvgwmagd")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Gets or sets the application port.
     */
    @JvmName("mfkugonctxdojdxi")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value WebApplication port mapping.
     */
    @JvmName("cnftgsmgefivelsp")
    public suspend fun portMapping(`value`: Output<PortMappingArgs>) {
        this.portMapping = value
    }

    /**
     * @param value Gets or sets the protocol.
     */
    @JvmName("bcddqaocpookqqge")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value WebApplication certificate.
     */
    @JvmName("bpmrkffpopobimvh")
    public suspend fun cert(`value`: CertArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cert = mapped
    }

    /**
     * @param argument WebApplication certificate.
     */
    @JvmName("xcduuudgrjbtfgtt")
    public suspend fun cert(argument: suspend CertArgsBuilder.() -> Unit) {
        val toBeMapped = CertArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cert = mapped
    }

    /**
     * @param value Gets or sets the binding host name.
     */
    @JvmName("ylaajgjfpvyncgbv")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Gets or sets the IP Address.
     */
    @JvmName("ubqgpvyatjhwytko")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Gets or sets the application port.
     */
    @JvmName("detnlrmdxnvmjaln")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value WebApplication port mapping.
     */
    @JvmName("lhcvfsksrjqioksa")
    public suspend fun portMapping(`value`: PortMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portMapping = mapped
    }

    /**
     * @param argument WebApplication port mapping.
     */
    @JvmName("cfwfigvegewpxiqf")
    public suspend fun portMapping(argument: suspend PortMappingArgsBuilder.() -> Unit) {
        val toBeMapped = PortMappingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.portMapping = mapped
    }

    /**
     * @param value Gets or sets the protocol.
     */
    @JvmName("lcgqmhtpmgsnirhc")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): BindingArgs = BindingArgs(
        cert = cert,
        hostName = hostName,
        ipAddress = ipAddress,
        port = port,
        portMapping = portMapping,
        protocol = protocol,
    )
}
