@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Collector agent SPN details class.
 * @property applicationId Gets the AAD application id.
 * @property audience Gets the AAD audience url.
 * @property authority Gets the AAD authority endpoint.
 * @property objectId Gets the object id of the AAD application.
 * @property tenantId Gets the tenant id of the AAD application.
 */
public data class CollectorAgentSpnPropertiesBaseArgs(
    public val applicationId: Output<String>? = null,
    public val audience: Output<String>? = null,
    public val authority: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs =
        com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .audience(audience?.applyValue({ args0 -> args0 }))
            .authority(authority?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CollectorAgentSpnPropertiesBaseArgs].
 */
@PulumiTagMarker
public class CollectorAgentSpnPropertiesBaseArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var audience: Output<String>? = null

    private var authority: Output<String>? = null

    private var objectId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Gets the AAD application id.
     */
    @JvmName("nwyvcgvqckqsoola")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Gets the AAD audience url.
     */
    @JvmName("tgpktgprotdkqbvx")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value Gets the AAD authority endpoint.
     */
    @JvmName("qjdvxsgmakfxghfs")
    public suspend fun authority(`value`: Output<String>) {
        this.authority = value
    }

    /**
     * @param value Gets the object id of the AAD application.
     */
    @JvmName("xbrelbfmmhwjkvnx")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Gets the tenant id of the AAD application.
     */
    @JvmName("airvmywkajncuifr")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Gets the AAD application id.
     */
    @JvmName("methmnlymgkmnsog")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Gets the AAD audience url.
     */
    @JvmName("sduyimrnbmikoknt")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value Gets the AAD authority endpoint.
     */
    @JvmName("xbrssecedwjxmgqw")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authority = mapped
    }

    /**
     * @param value Gets the object id of the AAD application.
     */
    @JvmName("ipcwceegsejimcjn")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Gets the tenant id of the AAD application.
     */
    @JvmName("sdhnoabhfdhompbw")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): CollectorAgentSpnPropertiesBaseArgs = CollectorAgentSpnPropertiesBaseArgs(
        applicationId = applicationId,
        audience = audience,
        authority = authority,
        objectId = objectId,
        tenantId = tenantId,
    )
}
