@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Compute settings.
 * @property hyperthreadCoreToMemoryRatio Hyperthread core to memory ratio.
 * @property price Compute Price.
 * @property sqlServerLicensing SQL Server licensing settings.
 * @property virtualizationSoftwareSettings Virtualization software settings.
 * @property windowsServerLicensing Windows Server licensing settings.
 */
public data class ComputeSettingsArgs(
    public val hyperthreadCoreToMemoryRatio: Output<Double>,
    public val price: Output<Double>,
    public val sqlServerLicensing: Output<List<SqlServerLicensingSettingsArgs>>,
    public val virtualizationSoftwareSettings: Output<VirtualizationSoftwareSettingsArgs>,
    public val windowsServerLicensing: Output<WindowsServerLicensingSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs.builder()
            .hyperthreadCoreToMemoryRatio(hyperthreadCoreToMemoryRatio.applyValue({ args0 -> args0 }))
            .price(price.applyValue({ args0 -> args0 }))
            .sqlServerLicensing(
                sqlServerLicensing.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualizationSoftwareSettings(
                virtualizationSoftwareSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .windowsServerLicensing(
                windowsServerLicensing.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ComputeSettingsArgs].
 */
@PulumiTagMarker
public class ComputeSettingsArgsBuilder internal constructor() {
    private var hyperthreadCoreToMemoryRatio: Output<Double>? = null

    private var price: Output<Double>? = null

    private var sqlServerLicensing: Output<List<SqlServerLicensingSettingsArgs>>? = null

    private var virtualizationSoftwareSettings: Output<VirtualizationSoftwareSettingsArgs>? = null

    private var windowsServerLicensing: Output<WindowsServerLicensingSettingsArgs>? = null

    /**
     * @param value Hyperthread core to memory ratio.
     */
    @JvmName("oshkopdkqbcarpgq")
    public suspend fun hyperthreadCoreToMemoryRatio(`value`: Output<Double>) {
        this.hyperthreadCoreToMemoryRatio = value
    }

    /**
     * @param value Compute Price.
     */
    @JvmName("kdmbqiowdrvajcxo")
    public suspend fun price(`value`: Output<Double>) {
        this.price = value
    }

    /**
     * @param value SQL Server licensing settings.
     */
    @JvmName("soiwawuixjllebdu")
    public suspend fun sqlServerLicensing(`value`: Output<List<SqlServerLicensingSettingsArgs>>) {
        this.sqlServerLicensing = value
    }

    @JvmName("xdbxyofmpuuciqxj")
    public suspend fun sqlServerLicensing(vararg values: Output<SqlServerLicensingSettingsArgs>) {
        this.sqlServerLicensing = Output.all(values.asList())
    }

    /**
     * @param values SQL Server licensing settings.
     */
    @JvmName("onwvyredyhksiure")
    public suspend fun sqlServerLicensing(values: List<Output<SqlServerLicensingSettingsArgs>>) {
        this.sqlServerLicensing = Output.all(values)
    }

    /**
     * @param value Virtualization software settings.
     */
    @JvmName("ypkauwpvvladyxwq")
    public suspend
    fun virtualizationSoftwareSettings(`value`: Output<VirtualizationSoftwareSettingsArgs>) {
        this.virtualizationSoftwareSettings = value
    }

    /**
     * @param value Windows Server licensing settings.
     */
    @JvmName("qdbcctarbnncjitb")
    public suspend fun windowsServerLicensing(`value`: Output<WindowsServerLicensingSettingsArgs>) {
        this.windowsServerLicensing = value
    }

    /**
     * @param value Hyperthread core to memory ratio.
     */
    @JvmName("jfjgeyreegtvdaii")
    public suspend fun hyperthreadCoreToMemoryRatio(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperthreadCoreToMemoryRatio = mapped
    }

    /**
     * @param value Compute Price.
     */
    @JvmName("lrwjfaxsthcnmgcp")
    public suspend fun price(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.price = mapped
    }

    /**
     * @param value SQL Server licensing settings.
     */
    @JvmName("pwluhidwfyrgybcl")
    public suspend fun sqlServerLicensing(`value`: List<SqlServerLicensingSettingsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicensing = mapped
    }

    /**
     * @param argument SQL Server licensing settings.
     */
    @JvmName("qdaouylfbfgnygmv")
    public suspend
    fun sqlServerLicensing(argument: List<suspend SqlServerLicensingSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlServerLicensingSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlServerLicensing = mapped
    }

    /**
     * @param argument SQL Server licensing settings.
     */
    @JvmName("hagdrjgaooeahsmh")
    public suspend fun sqlServerLicensing(
        vararg
        argument: suspend SqlServerLicensingSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SqlServerLicensingSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlServerLicensing = mapped
    }

    /**
     * @param argument SQL Server licensing settings.
     */
    @JvmName("cknyawxeuybenhoj")
    public suspend
    fun sqlServerLicensing(argument: suspend SqlServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SqlServerLicensingSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sqlServerLicensing = mapped
    }

    /**
     * @param values SQL Server licensing settings.
     */
    @JvmName("awrklfqmqusnvyam")
    public suspend fun sqlServerLicensing(vararg values: SqlServerLicensingSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicensing = mapped
    }

    /**
     * @param value Virtualization software settings.
     */
    @JvmName("hlmcuiugspjiflgf")
    public suspend fun virtualizationSoftwareSettings(`value`: VirtualizationSoftwareSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualizationSoftwareSettings = mapped
    }

    /**
     * @param argument Virtualization software settings.
     */
    @JvmName("mdmbbqkvoocipuac")
    public suspend
    fun virtualizationSoftwareSettings(argument: suspend VirtualizationSoftwareSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualizationSoftwareSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualizationSoftwareSettings = mapped
    }

    /**
     * @param value Windows Server licensing settings.
     */
    @JvmName("lefuulmhnpffsmnx")
    public suspend fun windowsServerLicensing(`value`: WindowsServerLicensingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsServerLicensing = mapped
    }

    /**
     * @param argument Windows Server licensing settings.
     */
    @JvmName("abtvkmvyvqwleybd")
    public suspend
    fun windowsServerLicensing(argument: suspend WindowsServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsServerLicensingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsServerLicensing = mapped
    }

    internal fun build(): ComputeSettingsArgs = ComputeSettingsArgs(
        hyperthreadCoreToMemoryRatio = hyperthreadCoreToMemoryRatio ?: throw
            PulumiNullFieldException("hyperthreadCoreToMemoryRatio"),
        price = price ?: throw PulumiNullFieldException("price"),
        sqlServerLicensing = sqlServerLicensing ?: throw PulumiNullFieldException("sqlServerLicensing"),
        virtualizationSoftwareSettings = virtualizationSoftwareSettings ?: throw
            PulumiNullFieldException("virtualizationSoftwareSettings"),
        windowsServerLicensing = windowsServerLicensing ?: throw
            PulumiNullFieldException("windowsServerLicensing"),
    )
}
