@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.FacilitySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Facility settings.
 * @property facilitiesCost The facilities cost.
 */
public data class FacilitySettingsArgs(
    public val facilitiesCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.FacilitySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.FacilitySettingsArgs =
        com.pulumi.azurenative.migrate.inputs.FacilitySettingsArgs.builder()
            .facilitiesCost(facilitiesCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FacilitySettingsArgs].
 */
@PulumiTagMarker
public class FacilitySettingsArgsBuilder internal constructor() {
    private var facilitiesCost: Output<Double>? = null

    /**
     * @param value The facilities cost.
     */
    @JvmName("psgjcjvnqdmqpgat")
    public suspend fun facilitiesCost(`value`: Output<Double>) {
        this.facilitiesCost = value
    }

    /**
     * @param value The facilities cost.
     */
    @JvmName("jtljklsgcqehvvjw")
    public suspend fun facilitiesCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.facilitiesCost = mapped
    }

    internal fun build(): FacilitySettingsArgs = FacilitySettingsArgs(
        facilitiesCost = facilitiesCost ?: throw PulumiNullFieldException("facilitiesCost"),
    )
}
