@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetMigrateAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentName MigrateAgent name.
 * @property modernizeProjectName ModernizeProject name.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 */
public data class GetMigrateAgentPlainArgs(
    public val agentName: String,
    public val modernizeProjectName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetMigrateAgentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetMigrateAgentPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetMigrateAgentPlainArgs.builder()
            .agentName(agentName.let({ args0 -> args0 }))
            .modernizeProjectName(modernizeProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMigrateAgentPlainArgs].
 */
@PulumiTagMarker
public class GetMigrateAgentPlainArgsBuilder internal constructor() {
    private var agentName: String? = null

    private var modernizeProjectName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value MigrateAgent name.
     */
    @JvmName("kgcpgiosegtttake")
    public suspend fun agentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentName = mapped
    }

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("ygcweabfusrqgaqh")
    public suspend fun modernizeProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("nqlqhmicghqramkv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("scmeldwmcefdwhaa")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetMigrateAgentPlainArgs = GetMigrateAgentPlainArgs(
        agentName = agentName ?: throw PulumiNullFieldException("agentName"),
        modernizeProjectName = modernizeProjectName ?: throw
            PulumiNullFieldException("modernizeProjectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
