@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetProjectPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetProjectPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetProjectPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetProjectPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectPlainArgs].
 */
@PulumiTagMarker
public class GetProjectPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("gqrujmnkxqbduhvt")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("vidhjmrrawylkfbe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProjectPlainArgs = GetProjectPlainArgs(
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
