@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetSolutionsControllerConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property solutionName Unique name of a migration solution within a migrate project.
 */
public data class GetSolutionsControllerConfigPlainArgs(
    public val migrateProjectName: String,
    public val resourceGroupName: String,
    public val solutionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetSolutionsControllerConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetSolutionsControllerConfigPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetSolutionsControllerConfigPlainArgs.builder()
            .migrateProjectName(migrateProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .solutionName(solutionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSolutionsControllerConfigPlainArgs].
 */
@PulumiTagMarker
public class GetSolutionsControllerConfigPlainArgsBuilder internal constructor() {
    private var migrateProjectName: String? = null

    private var resourceGroupName: String? = null

    private var solutionName: String? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("mkgwcdiweetvymnw")
    public suspend fun migrateProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrateProjectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lfcjrkctfluemctw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a migration solution within a migrate project.
     */
    @JvmName("jrajwyjumdexdfcc")
    public suspend fun solutionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.solutionName = mapped
    }

    internal fun build(): GetSolutionsControllerConfigPlainArgs =
        GetSolutionsControllerConfigPlainArgs(
            migrateProjectName = migrateProjectName ?: throw PulumiNullFieldException("migrateProjectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            solutionName = solutionName ?: throw PulumiNullFieldException("solutionName"),
        )
}
