@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetWebAppAssessmentV2OperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentName Web app Assessment arm name.
 * @property groupName Group ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWebAppAssessmentV2OperationPlainArgs(
    public val assessmentName: String,
    public val groupName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetWebAppAssessmentV2OperationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.GetWebAppAssessmentV2OperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetWebAppAssessmentV2OperationPlainArgs.builder()
            .assessmentName(assessmentName.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppAssessmentV2OperationPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppAssessmentV2OperationPlainArgsBuilder internal constructor() {
    private var assessmentName: String? = null

    private var groupName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Web app Assessment arm name.
     */
    @JvmName("triqpceauxgpquth")
    public suspend fun assessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentName = mapped
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("ovhrrtdmbelsgtoy")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ohhpdncjwtnehxie")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("grgxvmcgxcwwrujc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppAssessmentV2OperationPlainArgs =
        GetWebAppAssessmentV2OperationPlainArgs(
            assessmentName = assessmentName ?: throw PulumiNullFieldException("assessmentName"),
            groupName = groupName ?: throw PulumiNullFieldException("groupName"),
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
