@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetWorkloadDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modernizeProjectName ModernizeProject name.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 * @property workloadDeploymentName Workload deployment name.
 */
public data class GetWorkloadDeploymentPlainArgs(
    public val modernizeProjectName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
    public val workloadDeploymentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetWorkloadDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetWorkloadDeploymentPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetWorkloadDeploymentPlainArgs.builder()
            .modernizeProjectName(modernizeProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 }))
            .workloadDeploymentName(workloadDeploymentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadDeploymentPlainArgsBuilder internal constructor() {
    private var modernizeProjectName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    private var workloadDeploymentName: String? = null

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("flwnohanvogplkdb")
    public suspend fun modernizeProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("dkbvrobpswkrowpa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("lgqcqaqavffrvfgk")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    /**
     * @param value Workload deployment name.
     */
    @JvmName("plagijjkcxfhnuuq")
    public suspend fun workloadDeploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadDeploymentName = mapped
    }

    internal fun build(): GetWorkloadDeploymentPlainArgs = GetWorkloadDeploymentPlainArgs(
        modernizeProjectName = modernizeProjectName ?: throw
            PulumiNullFieldException("modernizeProjectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
        workloadDeploymentName = workloadDeploymentName ?: throw
            PulumiNullFieldException("workloadDeploymentName"),
    )
}
