@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetWorkloadInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modernizeProjectName ModernizeProject name.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 * @property workloadInstanceName Workload instance name.
 */
public data class GetWorkloadInstancePlainArgs(
    public val modernizeProjectName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
    public val workloadInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetWorkloadInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetWorkloadInstancePlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetWorkloadInstancePlainArgs.builder()
            .modernizeProjectName(modernizeProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 }))
            .workloadInstanceName(workloadInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadInstancePlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadInstancePlainArgsBuilder internal constructor() {
    private var modernizeProjectName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    private var workloadInstanceName: String? = null

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("oegwkuhsieduwggs")
    public suspend fun modernizeProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("keggvqljxcemrmbx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("fupccpkkgvvxiars")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    /**
     * @param value Workload instance name.
     */
    @JvmName("smccctxrvucrubxt")
    public suspend fun workloadInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadInstanceName = mapped
    }

    internal fun build(): GetWorkloadInstancePlainArgs = GetWorkloadInstancePlainArgs(
        modernizeProjectName = modernizeProjectName ?: throw
            PulumiNullFieldException("modernizeProjectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
        workloadInstanceName = workloadInstanceName ?: throw
            PulumiNullFieldException("workloadInstanceName"),
    )
}
