@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IISApplicationDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IISApplication details.
 * @property applicationPoolName Gets or sets the application pool name.
 * @property directories Gets or sets the list of directories.
 * @property enable32BitApiOnWin64 Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
 * @property managedPipelineMode Gets or sets the managed pipeline mode.
 * @property path Second level entity for virtual directories.
 * @property runtimeVersion Gets or sets the runtime version.
 */
public data class IISApplicationDetailsArgs(
    public val applicationPoolName: Output<String>? = null,
    public val directories: Output<List<DirectoryPathArgs>>? = null,
    public val enable32BitApiOnWin64: Output<Boolean>? = null,
    public val managedPipelineMode: Output<String>? = null,
    public val path: Output<DirectoryPathArgs>? = null,
    public val runtimeVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IISApplicationDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IISApplicationDetailsArgs =
        com.pulumi.azurenative.migrate.inputs.IISApplicationDetailsArgs.builder()
            .applicationPoolName(applicationPoolName?.applyValue({ args0 -> args0 }))
            .directories(
                directories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enable32BitApiOnWin64(enable32BitApiOnWin64?.applyValue({ args0 -> args0 }))
            .managedPipelineMode(managedPipelineMode?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IISApplicationDetailsArgs].
 */
@PulumiTagMarker
public class IISApplicationDetailsArgsBuilder internal constructor() {
    private var applicationPoolName: Output<String>? = null

    private var directories: Output<List<DirectoryPathArgs>>? = null

    private var enable32BitApiOnWin64: Output<Boolean>? = null

    private var managedPipelineMode: Output<String>? = null

    private var path: Output<DirectoryPathArgs>? = null

    private var runtimeVersion: Output<String>? = null

    /**
     * @param value Gets or sets the application pool name.
     */
    @JvmName("gapgqjgenckntuxe")
    public suspend fun applicationPoolName(`value`: Output<String>) {
        this.applicationPoolName = value
    }

    /**
     * @param value Gets or sets the list of directories.
     */
    @JvmName("eigtlaehqcojujla")
    public suspend fun directories(`value`: Output<List<DirectoryPathArgs>>) {
        this.directories = value
    }

    @JvmName("nuhgimtxmudskdiv")
    public suspend fun directories(vararg values: Output<DirectoryPathArgs>) {
        this.directories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of directories.
     */
    @JvmName("gupsvxijluhbqhgy")
    public suspend fun directories(values: List<Output<DirectoryPathArgs>>) {
        this.directories = Output.all(values)
    }

    /**
     * @param value Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
     */
    @JvmName("wreasmpusiivbwpl")
    public suspend fun enable32BitApiOnWin64(`value`: Output<Boolean>) {
        this.enable32BitApiOnWin64 = value
    }

    /**
     * @param value Gets or sets the managed pipeline mode.
     */
    @JvmName("otbrlgqtmexmremj")
    public suspend fun managedPipelineMode(`value`: Output<String>) {
        this.managedPipelineMode = value
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("nwukcdrfgrtwkbha")
    public suspend fun path(`value`: Output<DirectoryPathArgs>) {
        this.path = value
    }

    /**
     * @param value Gets or sets the runtime version.
     */
    @JvmName("jnncetmenbyaqwhl")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Gets or sets the application pool name.
     */
    @JvmName("bsftvnrdjwfeqcem")
    public suspend fun applicationPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationPoolName = mapped
    }

    /**
     * @param value Gets or sets the list of directories.
     */
    @JvmName("vatrlrndkrouilqj")
    public suspend fun directories(`value`: List<DirectoryPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets the list of directories.
     */
    @JvmName("kwlpsorgbdskoxnv")
    public suspend fun directories(argument: List<suspend DirectoryPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DirectoryPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets the list of directories.
     */
    @JvmName("pvgfjxqdcqfvgtda")
    public suspend fun directories(vararg argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DirectoryPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets the list of directories.
     */
    @JvmName("ykdqwoyegdnnyxvp")
    public suspend fun directories(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DirectoryPathArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param values Gets or sets the list of directories.
     */
    @JvmName("xrvilmcmbxptrgpd")
    public suspend fun directories(vararg values: DirectoryPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
     */
    @JvmName("htlouokmdmxrkoqk")
    public suspend fun enable32BitApiOnWin64(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable32BitApiOnWin64 = mapped
    }

    /**
     * @param value Gets or sets the managed pipeline mode.
     */
    @JvmName("vjtwadiwjcxylluy")
    public suspend fun managedPipelineMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPipelineMode = mapped
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("xkaoyppvvbmumkky")
    public suspend fun path(`value`: DirectoryPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Second level entity for virtual directories.
     */
    @JvmName("yroxwdirnoloilbd")
    public suspend fun path(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value Gets or sets the runtime version.
     */
    @JvmName("tsnpismhjnghsgad")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    internal fun build(): IISApplicationDetailsArgs = IISApplicationDetailsArgs(
        applicationPoolName = applicationPoolName,
        directories = directories,
        enable32BitApiOnWin64 = enable32BitApiOnWin64,
        managedPipelineMode = managedPipelineMode,
        path = path,
        runtimeVersion = runtimeVersion,
    )
}
