@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IISWebApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IISWeb application.
 * @property applicationId Gets or sets the web application id.
 * @property applicationName Gets or sets the web application name.
 * @property applicationScratchPath Gets or sets application scratch path.
 * @property applications Gets or sets the list of applications for the IIS web site.
 * @property bindings Gets or sets the bindings for the application.
 * @property configurations Gets or sets application configuration.
 * @property directories Gets or sets application directories.
 * @property discoveredFrameworks Gets or sets the discovered frameworks of application.
 * @property displayName Gets or sets the display name.
 * @property iisWebServer IISWeb server.
 * @property limits Resource Requirements.
 * @property path Second level entity for virtual directories.
 * @property primaryFramework Framework specific data for a web application.
 * @property requests Resource Requirements.
 * @property virtualApplications Gets or sets the list of application units for the web site.
 * @property webServerId Gets or sets the web server id.
 * @property webServerName Gets or sets the web server name.
 */
public data class IISWebApplicationArgs(
    public val applicationId: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val applicationScratchPath: Output<String>? = null,
    public val applications: Output<List<IISApplicationDetailsArgs>>? = null,
    public val bindings: Output<List<BindingArgs>>? = null,
    public val configurations: Output<List<WebApplicationConfigurationArgs>>? = null,
    public val directories: Output<List<WebApplicationDirectoryArgs>>? = null,
    public val discoveredFrameworks: Output<List<WebApplicationFrameworkArgs>>? = null,
    public val displayName: Output<String>? = null,
    public val iisWebServer: Output<IISWebServerArgs>? = null,
    public val limits: Output<ResourceRequirementsArgs>? = null,
    public val path: Output<DirectoryPathArgs>? = null,
    public val primaryFramework: Output<WebApplicationFrameworkArgs>? = null,
    public val requests: Output<ResourceRequirementsArgs>? = null,
    public val virtualApplications: Output<List<IISVirtualApplicationDetailsArgs>>? = null,
    public val webServerId: Output<String>? = null,
    public val webServerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IISWebApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IISWebApplicationArgs =
        com.pulumi.azurenative.migrate.inputs.IISWebApplicationArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .applicationScratchPath(applicationScratchPath?.applyValue({ args0 -> args0 }))
            .applications(
                applications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bindings(
                bindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .directories(
                directories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .discoveredFrameworks(
                discoveredFrameworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .iisWebServer(iisWebServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryFramework(primaryFramework?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requests(requests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualApplications(
                virtualApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .webServerId(webServerId?.applyValue({ args0 -> args0 }))
            .webServerName(webServerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IISWebApplicationArgs].
 */
@PulumiTagMarker
public class IISWebApplicationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var applicationScratchPath: Output<String>? = null

    private var applications: Output<List<IISApplicationDetailsArgs>>? = null

    private var bindings: Output<List<BindingArgs>>? = null

    private var configurations: Output<List<WebApplicationConfigurationArgs>>? = null

    private var directories: Output<List<WebApplicationDirectoryArgs>>? = null

    private var discoveredFrameworks: Output<List<WebApplicationFrameworkArgs>>? = null

    private var displayName: Output<String>? = null

    private var iisWebServer: Output<IISWebServerArgs>? = null

    private var limits: Output<ResourceRequirementsArgs>? = null

    private var path: Output<DirectoryPathArgs>? = null

    private var primaryFramework: Output<WebApplicationFrameworkArgs>? = null

    private var requests: Output<ResourceRequirementsArgs>? = null

    private var virtualApplications: Output<List<IISVirtualApplicationDetailsArgs>>? = null

    private var webServerId: Output<String>? = null

    private var webServerName: Output<String>? = null

    /**
     * @param value Gets or sets the web application id.
     */
    @JvmName("wvjmfufsoohqyhut")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Gets or sets the web application name.
     */
    @JvmName("logmmgfayffbffns")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Gets or sets application scratch path.
     */
    @JvmName("krgxheykocfyllle")
    public suspend fun applicationScratchPath(`value`: Output<String>) {
        this.applicationScratchPath = value
    }

    /**
     * @param value Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("mkfeqnmtupcoieij")
    public suspend fun applications(`value`: Output<List<IISApplicationDetailsArgs>>) {
        this.applications = value
    }

    @JvmName("ilvrxgsxxrdnqdib")
    public suspend fun applications(vararg values: Output<IISApplicationDetailsArgs>) {
        this.applications = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("ejfwbrrojuhylhud")
    public suspend fun applications(values: List<Output<IISApplicationDetailsArgs>>) {
        this.applications = Output.all(values)
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("rujwcjxshvloxbgp")
    public suspend fun bindings(`value`: Output<List<BindingArgs>>) {
        this.bindings = value
    }

    @JvmName("daqjsyicoqldhtbp")
    public suspend fun bindings(vararg values: Output<BindingArgs>) {
        this.bindings = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("bupeyevepbjoycvk")
    public suspend fun bindings(values: List<Output<BindingArgs>>) {
        this.bindings = Output.all(values)
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("vsbtoqtnnbbmbgmc")
    public suspend fun configurations(`value`: Output<List<WebApplicationConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("fxhlhinepetxhefn")
    public suspend fun configurations(vararg values: Output<WebApplicationConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("dblvbdjpdkkwgbfd")
    public suspend fun configurations(values: List<Output<WebApplicationConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("gqrohtglctrudbwy")
    public suspend fun directories(`value`: Output<List<WebApplicationDirectoryArgs>>) {
        this.directories = value
    }

    @JvmName("beuoaterfblpubow")
    public suspend fun directories(vararg values: Output<WebApplicationDirectoryArgs>) {
        this.directories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("ukannpsxupcmecfv")
    public suspend fun directories(values: List<Output<WebApplicationDirectoryArgs>>) {
        this.directories = Output.all(values)
    }

    /**
     * @param value Gets or sets the discovered frameworks of application.
     */
    @JvmName("cfqgjugsevyqaapk")
    public suspend fun discoveredFrameworks(`value`: Output<List<WebApplicationFrameworkArgs>>) {
        this.discoveredFrameworks = value
    }

    @JvmName("jriiqnmrduucgtat")
    public suspend fun discoveredFrameworks(vararg values: Output<WebApplicationFrameworkArgs>) {
        this.discoveredFrameworks = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the discovered frameworks of application.
     */
    @JvmName("evqgdwovpaluxpsf")
    public suspend fun discoveredFrameworks(values: List<Output<WebApplicationFrameworkArgs>>) {
        this.discoveredFrameworks = Output.all(values)
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("tyktkgcchbarbcgw")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value IISWeb server.
     */
    @JvmName("ewciditslwpegddp")
    public suspend fun iisWebServer(`value`: Output<IISWebServerArgs>) {
        this.iisWebServer = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("vfjampeodjqbadim")
    public suspend fun limits(`value`: Output<ResourceRequirementsArgs>) {
        this.limits = value
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("kifsporyafkbywhh")
    public suspend fun path(`value`: Output<DirectoryPathArgs>) {
        this.path = value
    }

    /**
     * @param value Framework specific data for a web application.
     */
    @JvmName("gumedetbdqxojpyb")
    public suspend fun primaryFramework(`value`: Output<WebApplicationFrameworkArgs>) {
        this.primaryFramework = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("ttgochouxfwobtjy")
    public suspend fun requests(`value`: Output<ResourceRequirementsArgs>) {
        this.requests = value
    }

    /**
     * @param value Gets or sets the list of application units for the web site.
     */
    @JvmName("hlfrkdcysjyvxonp")
    public suspend fun virtualApplications(`value`: Output<List<IISVirtualApplicationDetailsArgs>>) {
        this.virtualApplications = value
    }

    @JvmName("hidcqnsbcnhobvog")
    public suspend fun virtualApplications(vararg values: Output<IISVirtualApplicationDetailsArgs>) {
        this.virtualApplications = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of application units for the web site.
     */
    @JvmName("jrohjcaccxylusvk")
    public suspend fun virtualApplications(values: List<Output<IISVirtualApplicationDetailsArgs>>) {
        this.virtualApplications = Output.all(values)
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("bdpsfqdvumkunobi")
    public suspend fun webServerId(`value`: Output<String>) {
        this.webServerId = value
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("tlwukvuxypxcsvqy")
    public suspend fun webServerName(`value`: Output<String>) {
        this.webServerName = value
    }

    /**
     * @param value Gets or sets the web application id.
     */
    @JvmName("nrhsyodopkodgstg")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Gets or sets the web application name.
     */
    @JvmName("yqukleflaoolwwjf")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Gets or sets application scratch path.
     */
    @JvmName("txseghgeihylsvge")
    public suspend fun applicationScratchPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationScratchPath = mapped
    }

    /**
     * @param value Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("obvexauttvgnrxtw")
    public suspend fun applications(`value`: List<IISApplicationDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param argument Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("uawxhipvqelgkdyu")
    public suspend
    fun applications(argument: List<suspend IISApplicationDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IISApplicationDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applications = mapped
    }

    /**
     * @param argument Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("vyiekxlboixhjsov")
    public suspend fun applications(
        vararg
        argument: suspend IISApplicationDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IISApplicationDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applications = mapped
    }

    /**
     * @param argument Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("arimghdgjshimiyg")
    public suspend fun applications(argument: suspend IISApplicationDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IISApplicationDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.applications = mapped
    }

    /**
     * @param values Gets or sets the list of applications for the IIS web site.
     */
    @JvmName("raqkmrmtpwpwqkhc")
    public suspend fun applications(vararg values: IISApplicationDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("roeejpdhdhoplqbh")
    public suspend fun bindings(`value`: List<BindingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("ykhrwhvrofupdqop")
    public suspend fun bindings(argument: List<suspend BindingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("rncpjngcevkrytky")
    public suspend fun bindings(vararg argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("rrffdyikiatpgyev")
    public suspend fun bindings(argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BindingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("axqmjkswhhjfmpjl")
    public suspend fun bindings(vararg values: BindingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("hdawgtwxkubdhlwr")
    public suspend fun configurations(`value`: List<WebApplicationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("jbdeimowncgjocir")
    public suspend
    fun configurations(argument: List<suspend WebApplicationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("gqdpohlyfphgvqvo")
    public suspend fun configurations(
        vararg
        argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("hmlqqnhtnrminynh")
    public suspend
    fun configurations(argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("owtjpfbcpkexgsla")
    public suspend fun configurations(vararg values: WebApplicationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("kxyrjtvitawdunrf")
    public suspend fun directories(`value`: List<WebApplicationDirectoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("mkjfsopdastrqxox")
    public suspend
    fun directories(argument: List<suspend WebApplicationDirectoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("ikwspdgtcnrxjcip")
    public suspend fun directories(
        vararg
        argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("udsnagrglckvvhmq")
    public suspend fun directories(argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationDirectoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("ryljvlkowqhiynqy")
    public suspend fun directories(vararg values: WebApplicationDirectoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param value Gets or sets the discovered frameworks of application.
     */
    @JvmName("eubfpdqremxyusqd")
    public suspend fun discoveredFrameworks(`value`: List<WebApplicationFrameworkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("kchxjpyrdgjmvgse")
    public suspend
    fun discoveredFrameworks(argument: List<suspend WebApplicationFrameworkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationFrameworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("dmpmvqjutbycjakg")
    public suspend fun discoveredFrameworks(
        vararg
        argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationFrameworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("raoartvifaupuokf")
    public suspend
    fun discoveredFrameworks(argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationFrameworkArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param values Gets or sets the discovered frameworks of application.
     */
    @JvmName("abpvdxkyogpmngat")
    public suspend fun discoveredFrameworks(vararg values: WebApplicationFrameworkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveredFrameworks = mapped
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("kefysmobaekaijee")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value IISWeb server.
     */
    @JvmName("ncfxcydytjkpeiem")
    public suspend fun iisWebServer(`value`: IISWebServerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iisWebServer = mapped
    }

    /**
     * @param argument IISWeb server.
     */
    @JvmName("hgvxbepmvjsiggpa")
    public suspend fun iisWebServer(argument: suspend IISWebServerArgsBuilder.() -> Unit) {
        val toBeMapped = IISWebServerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.iisWebServer = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("cjhwycpqognvvnbg")
    public suspend fun limits(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("jngogvyifipgbodf")
    public suspend fun limits(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("ffveucfxwawvjowo")
    public suspend fun path(`value`: DirectoryPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Second level entity for virtual directories.
     */
    @JvmName("umiqmxfmoltwsvmi")
    public suspend fun path(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value Framework specific data for a web application.
     */
    @JvmName("uwxtjdkfoqhqasug")
    public suspend fun primaryFramework(`value`: WebApplicationFrameworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFramework = mapped
    }

    /**
     * @param argument Framework specific data for a web application.
     */
    @JvmName("fjaljeeqcvplmluc")
    public suspend
    fun primaryFramework(argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = WebApplicationFrameworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryFramework = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("wvdhtkgnpwlxfuht")
    public suspend fun requests(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("isqhhrofaromujxy")
    public suspend fun requests(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param value Gets or sets the list of application units for the web site.
     */
    @JvmName("thqjjayvihrqlvyh")
    public suspend fun virtualApplications(`value`: List<IISVirtualApplicationDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualApplications = mapped
    }

    /**
     * @param argument Gets or sets the list of application units for the web site.
     */
    @JvmName("rmbkadoiswrqfrfj")
    public suspend
    fun virtualApplications(argument: List<suspend IISVirtualApplicationDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IISVirtualApplicationDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param argument Gets or sets the list of application units for the web site.
     */
    @JvmName("xcwhthjfgaxvgpwu")
    public suspend fun virtualApplications(
        vararg
        argument: suspend IISVirtualApplicationDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IISVirtualApplicationDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param argument Gets or sets the list of application units for the web site.
     */
    @JvmName("phbgrckgdsiqakkb")
    public suspend
    fun virtualApplications(argument: suspend IISVirtualApplicationDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IISVirtualApplicationDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param values Gets or sets the list of application units for the web site.
     */
    @JvmName("wpncnpfwouueytua")
    public suspend fun virtualApplications(vararg values: IISVirtualApplicationDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualApplications = mapped
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("wofkqskhvqfffikl")
    public suspend fun webServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerId = mapped
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("hmebqtjyredihsse")
    public suspend fun webServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerName = mapped
    }

    internal fun build(): IISWebApplicationArgs = IISWebApplicationArgs(
        applicationId = applicationId,
        applicationName = applicationName,
        applicationScratchPath = applicationScratchPath,
        applications = applications,
        bindings = bindings,
        configurations = configurations,
        directories = directories,
        discoveredFrameworks = discoveredFrameworks,
        displayName = displayName,
        iisWebServer = iisWebServer,
        limits = limits,
        path = path,
        primaryFramework = primaryFramework,
        requests = requests,
        virtualApplications = virtualApplications,
        webServerId = webServerId,
        webServerName = webServerName,
    )
}
