@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IdentityModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity model.
 * @property aadAuthority Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
 * @property applicationId Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
 * service.
 * @property audience Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
 * @property objectId Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
 * @property tenantId Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
 */
public data class IdentityModelArgs(
    public val aadAuthority: Output<String>? = null,
    public val applicationId: Output<String>? = null,
    public val audience: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IdentityModelArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IdentityModelArgs =
        com.pulumi.azurenative.migrate.inputs.IdentityModelArgs.builder()
            .aadAuthority(aadAuthority?.applyValue({ args0 -> args0 }))
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .audience(audience?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityModelArgs].
 */
@PulumiTagMarker
public class IdentityModelArgsBuilder internal constructor() {
    private var aadAuthority: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var audience: Output<String>? = null

    private var objectId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("cmlmiqdqekvlngwt")
    public suspend fun aadAuthority(`value`: Output<String>) {
        this.aadAuthority = value
    }

    /**
     * @param value Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
     * service.
     */
    @JvmName("vksuufjakuyroblh")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("megiaecpjmvrvgcs")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("hrwrpojhyhfawsqg")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("dodbbbknijkgjixc")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("rruslhvbxsctkeyt")
    public suspend fun aadAuthority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAuthority = mapped
    }

    /**
     * @param value Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
     * service.
     */
    @JvmName("haoilkkkaylfppqm")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("hxplknqbpkqsrnxw")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("vuvmhnlunmtyiadr")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
     */
    @JvmName("lfxxnifwhivfichk")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): IdentityModelArgs = IdentityModelArgs(
        aadAuthority = aadAuthority,
        applicationId = applicationId,
        audience = audience,
        objectId = objectId,
        tenantId = tenantId,
    )
}
