@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.LBBackendAddressPoolResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines load balancer backend address pool properties.
 * @property name Gets or sets the backend address pool name.
 */
public data class LBBackendAddressPoolResourceSettingsArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.LBBackendAddressPoolResourceSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.LBBackendAddressPoolResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.LBBackendAddressPoolResourceSettingsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LBBackendAddressPoolResourceSettingsArgs].
 */
@PulumiTagMarker
public class LBBackendAddressPoolResourceSettingsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the backend address pool name.
     */
    @JvmName("rajwxkftojstoutf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the backend address pool name.
     */
    @JvmName("gcamwffglxgddamk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LBBackendAddressPoolResourceSettingsArgs =
        LBBackendAddressPoolResourceSettingsArgs(
            name = name,
        )
}
