@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ManagedIdentityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId
 * @property managedIdentityName
 * @property principalId
 * @property resourceGroup
 * @property subscriptionId
 * @property tenantId
 */
public data class ManagedIdentityPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val managedIdentityName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ManagedIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ManagedIdentityPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ManagedIdentityPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .managedIdentityName(managedIdentityName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedIdentityPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var managedIdentityName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lydbkgstylfaxdxi")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value
     */
    @JvmName("pcwragvjymhldtfm")
    public suspend fun managedIdentityName(`value`: Output<String>) {
        this.managedIdentityName = value
    }

    /**
     * @param value
     */
    @JvmName("impmawgnlhqfmaox")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value
     */
    @JvmName("feyivtfaktsfybok")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value
     */
    @JvmName("lqvjjmavoxdwmyre")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value
     */
    @JvmName("ualeschklnnrqmfi")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value
     */
    @JvmName("vhoyosiujhvxsfdg")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("yxigitwooboitxri")
    public suspend fun managedIdentityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentityName = mapped
    }

    /**
     * @param value
     */
    @JvmName("eglwrmyhjxbortqc")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fswapgfedovofwvq")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("xqiogcmdaygetyof")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("provjvrescccdlkc")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ManagedIdentityPropertiesArgs = ManagedIdentityPropertiesArgs(
        clientId = clientId,
        managedIdentityName = managedIdentityName,
        principalId = principalId,
        resourceGroup = resourceGroup,
        subscriptionId = subscriptionId,
        tenantId = tenantId,
    )
}
