@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MigrateProjectPropertiesArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a migrate project.
 * @property provisioningState Provisioning state of the migrate project.
 * @property publicNetworkAccess Gets or sets the state of public network access.
 * @property registeredTools Gets or sets the list of tools registered with the migrate project.
 * @property serviceEndpoint Service endpoint.
 * @property utilityStorageAccountId Utility storage account id.
 */
public data class MigrateProjectPropertiesArgs(
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val registeredTools: Output<List<String>>? = null,
    public val serviceEndpoint: Output<String>? = null,
    public val utilityStorageAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MigrateProjectPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MigrateProjectPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.MigrateProjectPropertiesArgs.builder()
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .registeredTools(registeredTools?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceEndpoint(serviceEndpoint?.applyValue({ args0 -> args0 }))
            .utilityStorageAccountId(utilityStorageAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateProjectPropertiesArgs].
 */
@PulumiTagMarker
public class MigrateProjectPropertiesArgsBuilder internal constructor() {
    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var registeredTools: Output<List<String>>? = null

    private var serviceEndpoint: Output<String>? = null

    private var utilityStorageAccountId: Output<String>? = null

    /**
     * @param value Provisioning state of the migrate project.
     */
    @JvmName("nytcymkxgbrmsjcp")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Gets or sets the state of public network access.
     */
    @JvmName("wkfbndnwoasonodh")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Gets or sets the list of tools registered with the migrate project.
     */
    @JvmName("lbhkvicvrwpdlnhv")
    public suspend fun registeredTools(`value`: Output<List<String>>) {
        this.registeredTools = value
    }

    @JvmName("islbxhmnvrcnfsji")
    public suspend fun registeredTools(vararg values: Output<String>) {
        this.registeredTools = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of tools registered with the migrate project.
     */
    @JvmName("noqhltxfphpwbaxt")
    public suspend fun registeredTools(values: List<Output<String>>) {
        this.registeredTools = Output.all(values)
    }

    /**
     * @param value Service endpoint.
     */
    @JvmName("msdmlisgxyhdtdyc")
    public suspend fun serviceEndpoint(`value`: Output<String>) {
        this.serviceEndpoint = value
    }

    /**
     * @param value Utility storage account id.
     */
    @JvmName("mxtbewaqogddftxs")
    public suspend fun utilityStorageAccountId(`value`: Output<String>) {
        this.utilityStorageAccountId = value
    }

    /**
     * @param value Provisioning state of the migrate project.
     */
    @JvmName("ecnlhovxaafuvfve")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the migrate project.
     */
    @JvmName("dukucwdgjmthavpe")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the migrate project.
     */
    @JvmName("awmnlicsvknrbexx")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Gets or sets the state of public network access.
     */
    @JvmName("gpvqffwenndojrtd")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets the list of tools registered with the migrate project.
     */
    @JvmName("jbqlwawtlxbbvobk")
    public suspend fun registeredTools(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registeredTools = mapped
    }

    /**
     * @param values Gets or sets the list of tools registered with the migrate project.
     */
    @JvmName("kwrwwebyiyeegpgx")
    public suspend fun registeredTools(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registeredTools = mapped
    }

    /**
     * @param value Service endpoint.
     */
    @JvmName("tfjtqbarxvhvvffh")
    public suspend fun serviceEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoint = mapped
    }

    /**
     * @param value Utility storage account id.
     */
    @JvmName("wvkmgjrfqghmihis")
    public suspend fun utilityStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.utilityStorageAccountId = mapped
    }

    internal fun build(): MigrateProjectPropertiesArgs = MigrateProjectPropertiesArgs(
        provisioningState = provisioningState,
        publicNetworkAccess = publicNetworkAccess,
        registeredTools = registeredTools,
        serviceEndpoint = serviceEndpoint,
        utilityStorageAccountId = utilityStorageAccountId,
    )
}
