@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.NetworkSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network settings.
 * @property hardwareSoftwareCostPercentage Network hardware and software cost percentage.
 * @property maintenanceCostPercentage Network maintenance cost percentage.
 */
public data class NetworkSettingsArgs(
    public val hardwareSoftwareCostPercentage: Output<Double>,
    public val maintenanceCostPercentage: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.NetworkSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.NetworkSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.NetworkSettingsArgs.builder()
            .hardwareSoftwareCostPercentage(hardwareSoftwareCostPercentage.applyValue({ args0 -> args0 }))
            .maintenanceCostPercentage(maintenanceCostPercentage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkSettingsArgs].
 */
@PulumiTagMarker
public class NetworkSettingsArgsBuilder internal constructor() {
    private var hardwareSoftwareCostPercentage: Output<Double>? = null

    private var maintenanceCostPercentage: Output<Double>? = null

    /**
     * @param value Network hardware and software cost percentage.
     */
    @JvmName("ppvraknosdlfbowc")
    public suspend fun hardwareSoftwareCostPercentage(`value`: Output<Double>) {
        this.hardwareSoftwareCostPercentage = value
    }

    /**
     * @param value Network maintenance cost percentage.
     */
    @JvmName("xdubcyvfvsajbjgr")
    public suspend fun maintenanceCostPercentage(`value`: Output<Double>) {
        this.maintenanceCostPercentage = value
    }

    /**
     * @param value Network hardware and software cost percentage.
     */
    @JvmName("dmyrrixnhgcerdba")
    public suspend fun hardwareSoftwareCostPercentage(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hardwareSoftwareCostPercentage = mapped
    }

    /**
     * @param value Network maintenance cost percentage.
     */
    @JvmName("gtlwlsjsnejrcopj")
    public suspend fun maintenanceCostPercentage(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceCostPercentage = mapped
    }

    internal fun build(): NetworkSettingsArgs = NetworkSettingsArgs(
        hardwareSoftwareCostPercentage = hardwareSoftwareCostPercentage ?: throw
            PulumiNullFieldException("hardwareSoftwareCostPercentage"),
        maintenanceCostPercentage = maintenanceCostPercentage ?: throw
            PulumiNullFieldException("maintenanceCostPercentage"),
    )
}
