@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.OtherManagementCostsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Other Management Costs Settings.
 * @property dataProtectionCostPerServerPerYear Data Protection Cost Per Server Per Year.
 * @property monitoringCostPerServerPerYear Monitoring Cost Per Server Per Year.
 * @property patchingCostPerServerPerYear Patching Cost Per Server Per Year.
 */
public data class OtherManagementCostsSettingsArgs(
    public val dataProtectionCostPerServerPerYear: Output<Double>,
    public val monitoringCostPerServerPerYear: Output<Double>,
    public val patchingCostPerServerPerYear: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.OtherManagementCostsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.OtherManagementCostsSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.OtherManagementCostsSettingsArgs.builder()
            .dataProtectionCostPerServerPerYear(
                dataProtectionCostPerServerPerYear.applyValue({ args0 ->
                    args0
                }),
            )
            .monitoringCostPerServerPerYear(monitoringCostPerServerPerYear.applyValue({ args0 -> args0 }))
            .patchingCostPerServerPerYear(patchingCostPerServerPerYear.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OtherManagementCostsSettingsArgs].
 */
@PulumiTagMarker
public class OtherManagementCostsSettingsArgsBuilder internal constructor() {
    private var dataProtectionCostPerServerPerYear: Output<Double>? = null

    private var monitoringCostPerServerPerYear: Output<Double>? = null

    private var patchingCostPerServerPerYear: Output<Double>? = null

    /**
     * @param value Data Protection Cost Per Server Per Year.
     */
    @JvmName("cajgqkglukjsqyex")
    public suspend fun dataProtectionCostPerServerPerYear(`value`: Output<Double>) {
        this.dataProtectionCostPerServerPerYear = value
    }

    /**
     * @param value Monitoring Cost Per Server Per Year.
     */
    @JvmName("fpwewpydppxwpfnd")
    public suspend fun monitoringCostPerServerPerYear(`value`: Output<Double>) {
        this.monitoringCostPerServerPerYear = value
    }

    /**
     * @param value Patching Cost Per Server Per Year.
     */
    @JvmName("qjichyxbmfyymgra")
    public suspend fun patchingCostPerServerPerYear(`value`: Output<Double>) {
        this.patchingCostPerServerPerYear = value
    }

    /**
     * @param value Data Protection Cost Per Server Per Year.
     */
    @JvmName("tvbdnikaigfvcbcf")
    public suspend fun dataProtectionCostPerServerPerYear(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataProtectionCostPerServerPerYear = mapped
    }

    /**
     * @param value Monitoring Cost Per Server Per Year.
     */
    @JvmName("ixfguoqmgxeidicf")
    public suspend fun monitoringCostPerServerPerYear(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringCostPerServerPerYear = mapped
    }

    /**
     * @param value Patching Cost Per Server Per Year.
     */
    @JvmName("fcqkraqtpiqmlatl")
    public suspend fun patchingCostPerServerPerYear(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchingCostPerServerPerYear = mapped
    }

    internal fun build(): OtherManagementCostsSettingsArgs = OtherManagementCostsSettingsArgs(
        dataProtectionCostPerServerPerYear = dataProtectionCostPerServerPerYear ?: throw
            PulumiNullFieldException("dataProtectionCostPerServerPerYear"),
        monitoringCostPerServerPerYear = monitoringCostPerServerPerYear ?: throw
            PulumiNullFieldException("monitoringCostPerServerPerYear"),
        patchingCostPerServerPerYear = patchingCostPerServerPerYear ?: throw
            PulumiNullFieldException("patchingCostPerServerPerYear"),
    )
}
