@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.PublicIpReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines reference to a public IP.
 * @property sourceArmResourceId Gets the ARM resource ID of the tracked resource being referenced.
 */
public data class PublicIpReferenceArgs(
    public val sourceArmResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.PublicIpReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.PublicIpReferenceArgs =
        com.pulumi.azurenative.migrate.inputs.PublicIpReferenceArgs.builder()
            .sourceArmResourceId(sourceArmResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublicIpReferenceArgs].
 */
@PulumiTagMarker
public class PublicIpReferenceArgsBuilder internal constructor() {
    private var sourceArmResourceId: Output<String>? = null

    /**
     * @param value Gets the ARM resource ID of the tracked resource being referenced.
     */
    @JvmName("vheybrftxmvrluqc")
    public suspend fun sourceArmResourceId(`value`: Output<String>) {
        this.sourceArmResourceId = value
    }

    /**
     * @param value Gets the ARM resource ID of the tracked resource being referenced.
     */
    @JvmName("tsoqyeuxpddvxofb")
    public suspend fun sourceArmResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceArmResourceId = mapped
    }

    internal fun build(): PublicIpReferenceArgs = PublicIpReferenceArgs(
        sourceArmResourceId = sourceArmResourceId ?: throw PulumiNullFieldException("sourceArmResourceId"),
    )
}
