@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SqlElasticPoolResourceSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ZoneRedundant
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the Sql ElasticPool resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Sql/servers/elasticPools'.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property zoneRedundant Defines the zone redundant resource setting.
 */
public data class SqlElasticPoolResourceSettingsArgs(
    public val resourceType: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
    public val zoneRedundant: Output<Either<String, ZoneRedundant>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SqlElasticPoolResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SqlElasticPoolResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SqlElasticPoolResourceSettingsArgs.builder()
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 }))
            .zoneRedundant(
                zoneRedundant?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlElasticPoolResourceSettingsArgs].
 */
@PulumiTagMarker
public class SqlElasticPoolResourceSettingsArgsBuilder internal constructor() {
    private var resourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    private var zoneRedundant: Output<Either<String, ZoneRedundant>>? = null

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Sql/servers/elasticPools'.
     */
    @JvmName("xmbsvbenlpxrfnik")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("jmdwknirqdhowcmy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("oqttcgxvvqlkvlpp")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("tcvluydddmflsnqi")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Defines the zone redundant resource setting.
     */
    @JvmName("dxtdeinlcsvkhlii")
    public suspend fun zoneRedundant(`value`: Output<Either<String, ZoneRedundant>>) {
        this.zoneRedundant = value
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Sql/servers/elasticPools'.
     */
    @JvmName("hnisbibnuyeaiifd")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("ippxywftnmrtfjvi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("jaqyqojmdhqhmtmu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("rkmwqpqplcndjogl")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("ycngxsqdpipmqxsx")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    /**
     * @param value Defines the zone redundant resource setting.
     */
    @JvmName("wospigiydskppbny")
    public suspend fun zoneRedundant(`value`: Either<String, ZoneRedundant>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    /**
     * @param value Defines the zone redundant resource setting.
     */
    @JvmName("nkiksrehnjugymxb")
    public fun zoneRedundant(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZoneRedundant>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    /**
     * @param value Defines the zone redundant resource setting.
     */
    @JvmName("jgevmppveqtiulcf")
    public fun zoneRedundant(`value`: ZoneRedundant) {
        val toBeMapped = Either.ofRight<String, ZoneRedundant>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): SqlElasticPoolResourceSettingsArgs = SqlElasticPoolResourceSettingsArgs(
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        tags = tags,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        zoneRedundant = zoneRedundant,
    )
}
