@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SubnetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines reference to subnet.
 * @property name Gets the name of the proxy resource on the target side.
 * @property sourceArmResourceId Gets the ARM resource ID of the tracked resource being referenced.
 */
public data class SubnetReferenceArgs(
    public val name: Output<String>? = null,
    public val sourceArmResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SubnetReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SubnetReferenceArgs =
        com.pulumi.azurenative.migrate.inputs.SubnetReferenceArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceArmResourceId(sourceArmResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetReferenceArgs].
 */
@PulumiTagMarker
public class SubnetReferenceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceArmResourceId: Output<String>? = null

    /**
     * @param value Gets the name of the proxy resource on the target side.
     */
    @JvmName("ekbxnraxukbgjlet")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets the ARM resource ID of the tracked resource being referenced.
     */
    @JvmName("rvsnuvwjndymjcin")
    public suspend fun sourceArmResourceId(`value`: Output<String>) {
        this.sourceArmResourceId = value
    }

    /**
     * @param value Gets the name of the proxy resource on the target side.
     */
    @JvmName("qoglfqhdxmaiduiy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets the ARM resource ID of the tracked resource being referenced.
     */
    @JvmName("wngpsiherwhbcfef")
    public suspend fun sourceArmResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceArmResourceId = mapped
    }

    internal fun build(): SubnetReferenceArgs = SubnetReferenceArgs(
        name = name,
        sourceArmResourceId = sourceArmResourceId ?: throw PulumiNullFieldException("sourceArmResourceId"),
    )
}
