@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.TargetStorageProfileArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.TargetHydrationStorageProviderType
import com.pulumi.azurenative.migrate.kotlin.enums.TargetStorageAccessType
import com.pulumi.azurenative.migrate.kotlin.enums.TargetStorageProjectionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage profile for the directory on the target container.
 * @property azureFileShareProfile Azure file share profile for hydration of application folders not mounted on
 * the container file system.
 * @property hydrationStorageProviderType Gets or sets the storage provider type on the target.
 * Applicable when StorageProjectionType is not ContainerFileSystem.
 * @property persistentVolumeId Gets or sets the target persistent volume id.
 * Applicable when StorageProjectionType is PersistentVolume and on using an
 * existing PersistentVolume.
 * @property storageAccessType Gets or sets the target storage access type.
 * @property storageProjectionType Gets or sets the target projection type.
 * @property targetName Gets or sets the name of the projected volume on the target environment.
 * @property targetSize Gets or sets the storage size on the target.
 * Applicable when StorageProjectionType is PersistentVolume and on creating a new
 * PersistentVolume.
 */
public data class TargetStorageProfileArgs(
    public val azureFileShareProfile: Output<AzureFileShareHydrationProfileArgs>? = null,
    public val hydrationStorageProviderType:
    Output<Either<String, TargetHydrationStorageProviderType>>? = null,
    public val persistentVolumeId: Output<String>? = null,
    public val storageAccessType: Output<Either<String, TargetStorageAccessType>>? = null,
    public val storageProjectionType: Output<Either<String, TargetStorageProjectionType>>? = null,
    public val targetName: Output<String>? = null,
    public val targetSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.TargetStorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.TargetStorageProfileArgs =
        com.pulumi.azurenative.migrate.inputs.TargetStorageProfileArgs.builder()
            .azureFileShareProfile(
                azureFileShareProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hydrationStorageProviderType(
                hydrationStorageProviderType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .persistentVolumeId(persistentVolumeId?.applyValue({ args0 -> args0 }))
            .storageAccessType(
                storageAccessType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .storageProjectionType(
                storageProjectionType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetName(targetName?.applyValue({ args0 -> args0 }))
            .targetSize(targetSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetStorageProfileArgs].
 */
@PulumiTagMarker
public class TargetStorageProfileArgsBuilder internal constructor() {
    private var azureFileShareProfile: Output<AzureFileShareHydrationProfileArgs>? = null

    private var hydrationStorageProviderType:
        Output<Either<String, TargetHydrationStorageProviderType>>? = null

    private var persistentVolumeId: Output<String>? = null

    private var storageAccessType: Output<Either<String, TargetStorageAccessType>>? = null

    private var storageProjectionType: Output<Either<String, TargetStorageProjectionType>>? = null

    private var targetName: Output<String>? = null

    private var targetSize: Output<String>? = null

    /**
     * @param value Azure file share profile for hydration of application folders not mounted on
     * the container file system.
     */
    @JvmName("phfcjcllvlgcwamk")
    public suspend fun azureFileShareProfile(`value`: Output<AzureFileShareHydrationProfileArgs>) {
        this.azureFileShareProfile = value
    }

    /**
     * @param value Gets or sets the storage provider type on the target.
     * Applicable when StorageProjectionType is not ContainerFileSystem.
     */
    @JvmName("dkkwpchyvwqtdmxx")
    public suspend
    fun hydrationStorageProviderType(`value`: Output<Either<String, TargetHydrationStorageProviderType>>) {
        this.hydrationStorageProviderType = value
    }

    /**
     * @param value Gets or sets the target persistent volume id.
     * Applicable when StorageProjectionType is PersistentVolume and on using an
     * existing PersistentVolume.
     */
    @JvmName("gprvimmejcfqkdpc")
    public suspend fun persistentVolumeId(`value`: Output<String>) {
        this.persistentVolumeId = value
    }

    /**
     * @param value Gets or sets the target storage access type.
     */
    @JvmName("hbaudpebbjddqkml")
    public suspend fun storageAccessType(`value`: Output<Either<String, TargetStorageAccessType>>) {
        this.storageAccessType = value
    }

    /**
     * @param value Gets or sets the target projection type.
     */
    @JvmName("babnyfpefnfhtwlf")
    public suspend
    fun storageProjectionType(`value`: Output<Either<String, TargetStorageProjectionType>>) {
        this.storageProjectionType = value
    }

    /**
     * @param value Gets or sets the name of the projected volume on the target environment.
     */
    @JvmName("xoiyxsieavgyuavd")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value Gets or sets the storage size on the target.
     * Applicable when StorageProjectionType is PersistentVolume and on creating a new
     * PersistentVolume.
     */
    @JvmName("jclrkelvqofrtukr")
    public suspend fun targetSize(`value`: Output<String>) {
        this.targetSize = value
    }

    /**
     * @param value Azure file share profile for hydration of application folders not mounted on
     * the container file system.
     */
    @JvmName("ookcubrjhkhanlbj")
    public suspend fun azureFileShareProfile(`value`: AzureFileShareHydrationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareProfile = mapped
    }

    /**
     * @param argument Azure file share profile for hydration of application folders not mounted on
     * the container file system.
     */
    @JvmName("pemduchrooshatov")
    public suspend
    fun azureFileShareProfile(argument: suspend AzureFileShareHydrationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileShareHydrationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFileShareProfile = mapped
    }

    /**
     * @param value Gets or sets the storage provider type on the target.
     * Applicable when StorageProjectionType is not ContainerFileSystem.
     */
    @JvmName("mjtxsdjnyesudctf")
    public suspend
    fun hydrationStorageProviderType(`value`: Either<String, TargetHydrationStorageProviderType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hydrationStorageProviderType = mapped
    }

    /**
     * @param value Gets or sets the storage provider type on the target.
     * Applicable when StorageProjectionType is not ContainerFileSystem.
     */
    @JvmName("ccippjhrcuyiiree")
    public fun hydrationStorageProviderType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetHydrationStorageProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hydrationStorageProviderType = mapped
    }

    /**
     * @param value Gets or sets the storage provider type on the target.
     * Applicable when StorageProjectionType is not ContainerFileSystem.
     */
    @JvmName("ipyierwexukodqjg")
    public fun hydrationStorageProviderType(`value`: TargetHydrationStorageProviderType) {
        val toBeMapped = Either.ofRight<String, TargetHydrationStorageProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hydrationStorageProviderType = mapped
    }

    /**
     * @param value Gets or sets the target persistent volume id.
     * Applicable when StorageProjectionType is PersistentVolume and on using an
     * existing PersistentVolume.
     */
    @JvmName("ufdoxghlxcoryejq")
    public suspend fun persistentVolumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistentVolumeId = mapped
    }

    /**
     * @param value Gets or sets the target storage access type.
     */
    @JvmName("aufkqcppjgkqbyme")
    public suspend fun storageAccessType(`value`: Either<String, TargetStorageAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccessType = mapped
    }

    /**
     * @param value Gets or sets the target storage access type.
     */
    @JvmName("qlxdkkactacllrby")
    public fun storageAccessType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetStorageAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccessType = mapped
    }

    /**
     * @param value Gets or sets the target storage access type.
     */
    @JvmName("waqxvyxwclgdxfyn")
    public fun storageAccessType(`value`: TargetStorageAccessType) {
        val toBeMapped = Either.ofRight<String, TargetStorageAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccessType = mapped
    }

    /**
     * @param value Gets or sets the target projection type.
     */
    @JvmName("vtbuveciyusoeodn")
    public suspend fun storageProjectionType(`value`: Either<String, TargetStorageProjectionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProjectionType = mapped
    }

    /**
     * @param value Gets or sets the target projection type.
     */
    @JvmName("ndojhfmxtsvtsvtd")
    public fun storageProjectionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetStorageProjectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageProjectionType = mapped
    }

    /**
     * @param value Gets or sets the target projection type.
     */
    @JvmName("gqjnaodbtjeyuoiv")
    public fun storageProjectionType(`value`: TargetStorageProjectionType) {
        val toBeMapped = Either.ofRight<String, TargetStorageProjectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageProjectionType = mapped
    }

    /**
     * @param value Gets or sets the name of the projected volume on the target environment.
     */
    @JvmName("hcnoayqwlqcnxwku")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    /**
     * @param value Gets or sets the storage size on the target.
     * Applicable when StorageProjectionType is PersistentVolume and on creating a new
     * PersistentVolume.
     */
    @JvmName("uktorfoppoqnhmox")
    public suspend fun targetSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSize = mapped
    }

    internal fun build(): TargetStorageProfileArgs = TargetStorageProfileArgs(
        azureFileShareProfile = azureFileShareProfile,
        hydrationStorageProviderType = hydrationStorageProviderType,
        persistentVolumeId = persistentVolumeId,
        storageAccessType = storageAccessType,
        storageProjectionType = storageProjectionType,
        targetName = targetName,
        targetSize = targetSize,
    )
}
