@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ThirdPartyManagementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Third Party Management settings.
 * @property licenseCost License Cost.
 * @property supportCost Support Cost.
 */
public data class ThirdPartyManagementSettingsArgs(
    public val licenseCost: Output<Double>,
    public val supportCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ThirdPartyManagementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ThirdPartyManagementSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.ThirdPartyManagementSettingsArgs.builder()
            .licenseCost(licenseCost.applyValue({ args0 -> args0 }))
            .supportCost(supportCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThirdPartyManagementSettingsArgs].
 */
@PulumiTagMarker
public class ThirdPartyManagementSettingsArgsBuilder internal constructor() {
    private var licenseCost: Output<Double>? = null

    private var supportCost: Output<Double>? = null

    /**
     * @param value License Cost.
     */
    @JvmName("ybmdufpoyftjawde")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value Support Cost.
     */
    @JvmName("udrfwanshrynxxxw")
    public suspend fun supportCost(`value`: Output<Double>) {
        this.supportCost = value
    }

    /**
     * @param value License Cost.
     */
    @JvmName("dlytgiywlywxarno")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    /**
     * @param value Support Cost.
     */
    @JvmName("solptikcjxmnqeck")
    public suspend fun supportCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportCost = mapped
    }

    internal fun build(): ThirdPartyManagementSettingsArgs = ThirdPartyManagementSettingsArgs(
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
        supportCost = supportCost ?: throw PulumiNullFieldException("supportCost"),
    )
}
