@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VMwareMigrateAgentModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMware MigrateAgent model custom properties.
 * @property fabricFriendlyName Gets or sets the friendly name of the,of the MigrateAgent fabric.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareMigrateAgentModelCustomProperties'.
 * @property vmwareSiteId Gets or sets the master Site Id of the Migrate Agent.
 */
public data class VMwareMigrateAgentModelCustomPropertiesArgs(
    public val fabricFriendlyName: Output<String>? = null,
    public val instanceType: Output<String>,
    public val vmwareSiteId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VMwareMigrateAgentModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.VMwareMigrateAgentModelCustomPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.VMwareMigrateAgentModelCustomPropertiesArgs.builder()
            .fabricFriendlyName(fabricFriendlyName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .vmwareSiteId(vmwareSiteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareMigrateAgentModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class VMwareMigrateAgentModelCustomPropertiesArgsBuilder internal constructor() {
    private var fabricFriendlyName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var vmwareSiteId: Output<String>? = null

    /**
     * @param value Gets or sets the friendly name of the,of the MigrateAgent fabric.
     */
    @JvmName("rvteietlsrkkyrds")
    public suspend fun fabricFriendlyName(`value`: Output<String>) {
        this.fabricFriendlyName = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMwareMigrateAgentModelCustomProperties'.
     */
    @JvmName("aaudsxgntdgtjgfw")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the master Site Id of the Migrate Agent.
     */
    @JvmName("jdioxsqyhgqaunun")
    public suspend fun vmwareSiteId(`value`: Output<String>) {
        this.vmwareSiteId = value
    }

    /**
     * @param value Gets or sets the friendly name of the,of the MigrateAgent fabric.
     */
    @JvmName("eurnfhbfajdadysn")
    public suspend fun fabricFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricFriendlyName = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMwareMigrateAgentModelCustomProperties'.
     */
    @JvmName("huyhbqxxvqtchsxi")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the master Site Id of the Migrate Agent.
     */
    @JvmName("grnpdkcnfmbvtsjw")
    public suspend fun vmwareSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmwareSiteId = mapped
    }

    internal fun build(): VMwareMigrateAgentModelCustomPropertiesArgs =
        VMwareMigrateAgentModelCustomPropertiesArgs(
            fabricFriendlyName = fabricFriendlyName,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            vmwareSiteId = vmwareSiteId,
        )
}
