@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VmUptimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details on the total up-time for the VM.
 * @property daysPerMonth Number of days in a month for VM uptime.
 * @property hoursPerDay Number of hours per day for VM uptime.
 */
public data class VmUptimeArgs(
    public val daysPerMonth: Output<Double>? = null,
    public val hoursPerDay: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VmUptimeArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VmUptimeArgs =
        com.pulumi.azurenative.migrate.inputs.VmUptimeArgs.builder()
            .daysPerMonth(daysPerMonth?.applyValue({ args0 -> args0 }))
            .hoursPerDay(hoursPerDay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmUptimeArgs].
 */
@PulumiTagMarker
public class VmUptimeArgsBuilder internal constructor() {
    private var daysPerMonth: Output<Double>? = null

    private var hoursPerDay: Output<Double>? = null

    /**
     * @param value Number of days in a month for VM uptime.
     */
    @JvmName("huacehkjthqgyylk")
    public suspend fun daysPerMonth(`value`: Output<Double>) {
        this.daysPerMonth = value
    }

    /**
     * @param value Number of hours per day for VM uptime.
     */
    @JvmName("jvfgdvcknoagdwrv")
    public suspend fun hoursPerDay(`value`: Output<Double>) {
        this.hoursPerDay = value
    }

    /**
     * @param value Number of days in a month for VM uptime.
     */
    @JvmName("jvsgbcbtwlhtlymu")
    public suspend fun daysPerMonth(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysPerMonth = mapped
    }

    /**
     * @param value Number of hours per day for VM uptime.
     */
    @JvmName("gqajlbkbrqdoxxyw")
    public suspend fun hoursPerDay(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hoursPerDay = mapped
    }

    internal fun build(): VmUptimeArgs = VmUptimeArgs(
        daysPerMonth = daysPerMonth,
        hoursPerDay = hoursPerDay,
    )
}
