@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VsphereManagementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Vsphere management settings.
 * @property licenseAndSupportList Licence and support list.
 */
public data class VsphereManagementSettingsArgs(
    public val licenseAndSupportList: Output<List<VsphereManagementLicenseArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VsphereManagementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VsphereManagementSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.VsphereManagementSettingsArgs.builder()
            .licenseAndSupportList(
                licenseAndSupportList.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VsphereManagementSettingsArgs].
 */
@PulumiTagMarker
public class VsphereManagementSettingsArgsBuilder internal constructor() {
    private var licenseAndSupportList: Output<List<VsphereManagementLicenseArgs>>? = null

    /**
     * @param value Licence and support list.
     */
    @JvmName("mevvpxnayecvmpqr")
    public suspend fun licenseAndSupportList(`value`: Output<List<VsphereManagementLicenseArgs>>) {
        this.licenseAndSupportList = value
    }

    @JvmName("mfsuvpwpodupufkw")
    public suspend fun licenseAndSupportList(vararg values: Output<VsphereManagementLicenseArgs>) {
        this.licenseAndSupportList = Output.all(values.asList())
    }

    /**
     * @param values Licence and support list.
     */
    @JvmName("ccuakieyylxycltl")
    public suspend fun licenseAndSupportList(values: List<Output<VsphereManagementLicenseArgs>>) {
        this.licenseAndSupportList = Output.all(values)
    }

    /**
     * @param value Licence and support list.
     */
    @JvmName("vfihmkobqmqtmntk")
    public suspend fun licenseAndSupportList(`value`: List<VsphereManagementLicenseArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("uukxlliuurqppgng")
    public suspend
    fun licenseAndSupportList(argument: List<suspend VsphereManagementLicenseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VsphereManagementLicenseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("nanqfvpntslkewhs")
    public suspend fun licenseAndSupportList(
        vararg
        argument: suspend VsphereManagementLicenseArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VsphereManagementLicenseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("ihprilkjoqnpomfl")
    public suspend
    fun licenseAndSupportList(argument: suspend VsphereManagementLicenseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VsphereManagementLicenseArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param values Licence and support list.
     */
    @JvmName("sxawgohpybfodceu")
    public suspend fun licenseAndSupportList(vararg values: VsphereManagementLicenseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseAndSupportList = mapped
    }

    internal fun build(): VsphereManagementSettingsArgs = VsphereManagementSettingsArgs(
        licenseAndSupportList = licenseAndSupportList ?: throw
            PulumiNullFieldException("licenseAndSupportList"),
    )
}
