@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.WorkloadDeploymentModelPropertiesArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.WorkloadDeploymentTarget
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Workload deployment model properties.
 * @property customProperties Workload deployment model custom properties.
 * @property displayName Gets or sets the display name.
 * @property targetPlatform Gets or sets the deployment target platform.
 * @property workloadInstanceProperties Workload instance model properties.
 */
public data class WorkloadDeploymentModelPropertiesArgs(
    public val customProperties:
    Output<Either<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs, IISAKSWorkloadDeploymentModelCustomPropertiesArgs>>? =
        null,
    public val displayName: Output<String>? = null,
    public val targetPlatform: Output<Either<String, WorkloadDeploymentTarget>>? = null,
    public val workloadInstanceProperties: Output<WorkloadInstanceModelPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.WorkloadDeploymentModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.WorkloadDeploymentModelPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.WorkloadDeploymentModelPropertiesArgs.builder()
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .targetPlatform(
                targetPlatform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workloadInstanceProperties(
                workloadInstanceProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkloadDeploymentModelPropertiesArgs].
 */
@PulumiTagMarker
public class WorkloadDeploymentModelPropertiesArgsBuilder internal constructor() {
    private var customProperties:
        Output<Either<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs, IISAKSWorkloadDeploymentModelCustomPropertiesArgs>>? =
        null

    private var displayName: Output<String>? = null

    private var targetPlatform: Output<Either<String, WorkloadDeploymentTarget>>? = null

    private var workloadInstanceProperties: Output<WorkloadInstanceModelPropertiesArgs>? = null

    /**
     * @param value Workload deployment model custom properties.
     */
    @JvmName("ogqywfqavvmkdodh")
    public suspend
    fun customProperties(`value`: Output<Either<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs, IISAKSWorkloadDeploymentModelCustomPropertiesArgs>>) {
        this.customProperties = value
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("rykixxcqlqplipxm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Gets or sets the deployment target platform.
     */
    @JvmName("sakyxkthebugqofn")
    public suspend fun targetPlatform(`value`: Output<Either<String, WorkloadDeploymentTarget>>) {
        this.targetPlatform = value
    }

    /**
     * @param value Workload instance model properties.
     */
    @JvmName("gkppflllxmhhjguc")
    public suspend
    fun workloadInstanceProperties(`value`: Output<WorkloadInstanceModelPropertiesArgs>) {
        this.workloadInstanceProperties = value
    }

    /**
     * @param value Workload deployment model custom properties.
     */
    @JvmName("dyvsunxytcahftmj")
    public suspend
    fun customProperties(`value`: Either<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs, IISAKSWorkloadDeploymentModelCustomPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Workload deployment model custom properties.
     */
    @JvmName("iinfkynyekbgjaix")
    public fun customProperties(`value`: ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofLeft<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs,
            IISAKSWorkloadDeploymentModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Workload deployment model custom properties.
     */
    @JvmName("gnbhnwivevhmcuwq")
    public fun customProperties(`value`: IISAKSWorkloadDeploymentModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofRight<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs,
            IISAKSWorkloadDeploymentModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("qmsrkoyaxckjoool")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Gets or sets the deployment target platform.
     */
    @JvmName("gmufcmmnwqxlwjer")
    public suspend fun targetPlatform(`value`: Either<String, WorkloadDeploymentTarget>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Gets or sets the deployment target platform.
     */
    @JvmName("yfcwjvouytrwsvga")
    public fun targetPlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadDeploymentTarget>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Gets or sets the deployment target platform.
     */
    @JvmName("jlxbiwjalvdupeoi")
    public fun targetPlatform(`value`: WorkloadDeploymentTarget) {
        val toBeMapped = Either.ofRight<String, WorkloadDeploymentTarget>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Workload instance model properties.
     */
    @JvmName("wpeayccoqdgelypn")
    public suspend fun workloadInstanceProperties(`value`: WorkloadInstanceModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadInstanceProperties = mapped
    }

    /**
     * @param argument Workload instance model properties.
     */
    @JvmName("otbbgfdttapxgjky")
    public suspend
    fun workloadInstanceProperties(argument: suspend WorkloadInstanceModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WorkloadInstanceModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workloadInstanceProperties = mapped
    }

    internal fun build(): WorkloadDeploymentModelPropertiesArgs =
        WorkloadDeploymentModelPropertiesArgs(
            customProperties = customProperties,
            displayName = displayName,
            targetPlatform = targetPlatform,
            workloadInstanceProperties = workloadInstanceProperties,
        )
}
