@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Data model of AKS Assessment Details.
 * @property confidenceRatingInPercentage Gets Confidence score.
 * @property createdTimestamp Gets date and time when assessment was created.
 * @property machineCount Gets the number of machines.
 * @property pricesTimestamp Gets last time when rates were queried.
 * @property status Gets assessment status.
 * @property totalMonthlyCost Gets the total monthly cost.
 * @property updatedTimestamp Gets date and time when assessment was last updated.
 * @property webAppCount Gets the number of web apps.
 * @property webServerCount Gets the number of web servers.
 */
public data class AKSAssessmentDetailsResponse(
    public val confidenceRatingInPercentage: Double,
    public val createdTimestamp: String,
    public val machineCount: Int,
    public val pricesTimestamp: String,
    public val status: String,
    public val totalMonthlyCost: Double,
    public val updatedTimestamp: String,
    public val webAppCount: Int,
    public val webServerCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AKSAssessmentDetailsResponse):
            AKSAssessmentDetailsResponse = AKSAssessmentDetailsResponse(
            confidenceRatingInPercentage = javaType.confidenceRatingInPercentage(),
            createdTimestamp = javaType.createdTimestamp(),
            machineCount = javaType.machineCount(),
            pricesTimestamp = javaType.pricesTimestamp(),
            status = javaType.status(),
            totalMonthlyCost = javaType.totalMonthlyCost(),
            updatedTimestamp = javaType.updatedTimestamp(),
            webAppCount = javaType.webAppCount(),
            webServerCount = javaType.webServerCount(),
        )
    }
}
