@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * WebApplication certificate.
 * @property certData Gets or sets the Certificate data.
 * @property certNeeded Gets or sets a value indicating whether certificate is needed or not.
 * @property certProvided Gets or sets a value indicating whether certificate is provided or not.
 * @property secretStore Gets or sets the type of secret store for the certificate.
 */
public data class CertResponse(
    public val certData: String? = null,
    public val certNeeded: Boolean? = null,
    public val certProvided: Boolean? = null,
    public val secretStore: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CertResponse): CertResponse =
            CertResponse(
                certData = javaType.certData().map({ args0 -> args0 }).orElse(null),
                certNeeded = javaType.certNeeded().map({ args0 -> args0 }).orElse(null),
                certProvided = javaType.certProvided().map({ args0 -> args0 }).orElse(null),
                secretStore = javaType.secretStore().map({ args0 -> args0 }).orElse(null),
            )
    }
}
