@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id
 * @property lastHeartbeatUtc
 * @property spnDetails
 * @property version
 */
public data class CollectorAgentPropertiesResponse(
    public val id: String,
    public val lastHeartbeatUtc: String,
    public val spnDetails: CollectorBodyAgentSpnPropertiesResponse? = null,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CollectorAgentPropertiesResponse):
            CollectorAgentPropertiesResponse = CollectorAgentPropertiesResponse(
            id = javaType.id(),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            spnDetails = javaType.spnDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.CollectorBodyAgentSpnPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            version = javaType.version(),
        )
    }
}
