@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for container image properties.
 * @property dockerfile Gets or sets the dockerfile for the container image.
 * @property id Gets the ID.
 * @property imageName Gets or sets the container image name.
 * @property imageTag Gets or sets the container image tag.
 * @property registryProperties Class for ACR Properties.
 * @property runId Gets or sets the RunId.
 * @property runStatus Gets or sets the RunStatus.
 */
public data class ContainerImagePropertiesResponse(
    public val dockerfile: String? = null,
    public val id: String,
    public val imageName: String? = null,
    public val imageTag: String? = null,
    public val registryProperties: ACRPropertiesResponse? = null,
    public val runId: String? = null,
    public val runStatus: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ContainerImagePropertiesResponse):
            ContainerImagePropertiesResponse = ContainerImagePropertiesResponse(
            dockerfile = javaType.dockerfile().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            imageTag = javaType.imageTag().map({ args0 -> args0 }).orElse(null),
            registryProperties = javaType.registryProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ACRPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runId = javaType.runId().map({ args0 -> args0 }).orElse(null),
            runStatus = javaType.runStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
