@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The database project summary class.
 * @property extendedSummary Gets or sets the extended summary.
 * @property instanceType Gets the Instance type.
 * Expected value is 'Databases'.
 * @property lastSummaryRefreshedTime Gets or sets the time when summary was last refreshed.
 * @property refreshSummaryState Gets or sets the state of refresh summary.
 */
public data class DatabaseProjectSummaryResponse(
    public val extendedSummary: Map<String, String>? = null,
    public val instanceType: String,
    public val lastSummaryRefreshedTime: String? = null,
    public val refreshSummaryState: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.DatabaseProjectSummaryResponse):
            DatabaseProjectSummaryResponse = DatabaseProjectSummaryResponse(
            extendedSummary = javaType.extendedSummary().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            instanceType = javaType.instanceType(),
            lastSummaryRefreshedTime = javaType.lastSummaryRefreshedTime().map({ args0 -> args0 }).orElse(null),
            refreshSummaryState = javaType.refreshSummaryState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
