@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class for deployed resource properties.
 * @property context Gets or sets the context of deployed resources.
 * @property deployedResourceId Gets or sets the deployed resource id.
 * @property deploymentTimestamp Gets or sets the deployment timestamp.
 * @property displayName Gets or sets the name of deployed resources.
 * @property id Gets or sets the ID.
 * @property isCleanUpDone Gets or sets a value indicating whether resources are cleaned up from target.
 * @property isTestMigration Gets or sets a value indicating whether scenario is test migration.
 * @property status Gets or sets the status of deployed resources.
 * @property type Gets or sets the type of deployed resources.
 */
public data class DeployedResourcesPropertiesResponse(
    public val context: String,
    public val deployedResourceId: String,
    public val deploymentTimestamp: String,
    public val displayName: String,
    public val id: String,
    public val isCleanUpDone: Boolean,
    public val isTestMigration: Boolean,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.DeployedResourcesPropertiesResponse):
            DeployedResourcesPropertiesResponse = DeployedResourcesPropertiesResponse(
            context = javaType.context(),
            deployedResourceId = javaType.deployedResourceId(),
            deploymentTimestamp = javaType.deploymentTimestamp(),
            displayName = javaType.displayName(),
            id = javaType.id(),
            isCleanUpDone = javaType.isCleanUpDone(),
            isTestMigration = javaType.isTestMigration(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
