@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Discovered entity light summary.
 * @property numberOfMachines Gets or sets the number of machines.
 * @property numberOfServers Gets or sets the number of servers.
 * @property numberOfWebApps Gets or sets the number of web apps.
 */
public data class DiscoveredEntityLightSummaryResponse(
    public val numberOfMachines: Int,
    public val numberOfServers: Int,
    public val numberOfWebApps: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.DiscoveredEntityLightSummaryResponse):
            DiscoveredEntityLightSummaryResponse = DiscoveredEntityLightSummaryResponse(
            numberOfMachines = javaType.numberOfMachines(),
            numberOfServers = javaType.numberOfServers(),
            numberOfWebApps = javaType.numberOfWebApps(),
        )
    }
}
